import SenzuFetchForm from "./forms/SenzuFetchForm.js";
import NewPageDataForm from "./forms/NewPageDataForm.js";
import NewVirtualParentForm from "./forms/NewVirtualParentForm.js";
import ImageManager from "./../image-manager/ImageManager.js";

class SenzuImporter{
	unsavedChanges = false;
	imageManager = null;

	constructor() {
		this.loadImageManager();

		window.addEventListener("beforeunload", e => {
			if (this.unsavedChanges){
				e.preventDefault();
				return "You have unsaved changes.";
			}
		});
	}

	loadImageManager(){
		this.imageManager = new ImageManager(document.querySelector("#image-manager-container"));
	}
}

export default new SenzuImporter();