import PageData from "../components/PageData.js";
import ManagePageData from "../modals/ManagePageData.js";

class NewPageDataForm{
	form = document.querySelector("#new-page-data-form");

	constructor() {
		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		const fData = new FormData(this.form);
		const dataType = fData.get("page-data-type");
		if (dataType !== "-1") {
			new PageData(ManagePageData.currentPageComponent, dataType, "");
		}
	}
}

export default new NewPageDataForm();