import BSModal from "../../_external/bootstrap/modal.js";
import PageData from "../components/PageData.js";

class ManagePageData{

	modal = document.querySelector("#manage-page-data-modal");
	bsModal = new BSModal(this.modal);

	/** @type {PageComponent|null} */
	currentPageComponent = null;

	constructor() {

	}

	setCurrentPageComponent(pageComponent){
		this.currentPageComponent = pageComponent;
	}

	/**
	 * @param {PageData[]} pageDatas
	 */
	loadPageDataDOMs(pageDatas){
		// Reloads an existing PageData object into the DOM and the cache
		for (const component of pageDatas){
			component.dom = component.getDOM();
			PageData.cache.push(component);
		}
	}

	/**
	 * Clears the DOMs of PageData components. The objects themselves still exist as references in the PageComponent
	 * arrays for page data and can be rebuilt that way.
	 */
	clearExistingDOMs(){
		PageData.clearAll();
	}

	show() {
		this.clearExistingDOMs();
		this.loadPageDataDOMs(this.currentPageComponent.pageDatas);
		this.bsModal.show();
	}

	hide(){
		this.bsModal.hide();
	}
}

export default new ManagePageData();