import Endpoints from "../../Endpoints.js";
import Scheduler from "../../utils/Scheduler.js";

class RobotSettingsForm {
	/**
	 * @type {HTMLFormElement}
	 */
	form;
	/**
	 * @type {HTMLButtonElement}
	 */
	submitButton
	/**
	 * @type {boolean}
	 */
	isSubmitting = false;

	constructor(){
		this.form = document.querySelector("#robot-settings-form");
		this.submitButton = this.form.querySelector(`button[type="submit"]`);
		this.isSubmitting = false;

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	/**
	 * Fired when the form is submitted.
	 */
	async onSubmit() {
		if (this.isSubmitting){
			return;
		}

		this.isSubmitting = true;
		this.submitButton.querySelector("span").textContent = "Saving...";
		this.submitButton.classList.add("disabled");

		const fData = new FormData(this.form);
		const response = await fetch(`/uplift/settings/robots`, {
			credentials:"same-origin",
			cache:"no-cache",
			body:fData,
			method:"PATCH"
		});

		await Scheduler.wait(150);

		if (response.status === 200){
			const data = await response.json();
			if (data.status === 1){

			}else if (data.status === -1){
				console.warn(data.error);
			}
		}else{
			console.warn(await response.text());
		}

		this.submitButton.querySelector("span").textContent = "Save Robots";
		this.submitButton.classList.remove("disabled");
		this.isSubmitting = false;
	}
}

export default new RobotSettingsForm();
