import Endpoints from "../Endpoints.js";
import { ThemeItem } from "./components/ThemeItem.js";

export class ThemeImporter {
	errorMessage = document.querySelector("#theme-installation-error");
	themeLoader = document.querySelector("#theme-loader");
	themeContainer = document.querySelector("#themes");
	paginationContainer = document.querySelector("#pagination-container");
	overwriteCheckbox = document.querySelector("#overwrite-checkbox");
	themeManagerUrl = "https://theme-manager.footbridgemobile.com";

	constructor() {
		this.initialize();
	}

	async initialize() {
		const themeData = await this.getThemes(1, 10);

		for(const theme of themeData.Objects) {
			new ThemeItem(this, theme, this.themeManagerUrl)
				.build()
				.renderInto(this.themeContainer);
		}

		// TODO: handle pagination

		this.themeLoader.style.display = "none";
	}

	async getThemes(pageNumber, limit) {
		const urlParams = new URLSearchParams();

		urlParams.set("pageNumber", String(pageNumber));
		urlParams.set("limit", String(limit));

		const response = await fetch(`${this.themeManagerUrl}/query-themes?${urlParams.toString()}`, {
			cache:"no-cache",
			credentials:"same-origin",
			method:"get",
		});

		let data = await response.json();

		if(data.StatusCode === 200) {
			return data.Data;
		} else {
			this.errorMessage.style.display = "block";
			this.errorMessage.innerHTML = "Unable to connect with theme server. Please contact an administrator.";
		}
	}

	async downloadTheme(themeURL) {
		const urlParams = new URLSearchParams();

		urlParams.set("theme-url", String(themeURL));
		urlParams.set("overwrite", String(this.overwriteCheckbox.checked));

		const response = await fetch(`${Endpoints.themeImporter.downloadTheme}?${urlParams.toString()}`, {
			cache:"no-cache",
			credentials:"same-origin",
			method:"get",
		});

		let data = await response.json();

		if (data.status === 1) {
			// TODO: Future addition - Redirect to customization form
			window.location.href = "/uplift/theme-manager";
		} else if (data.status === -1){
			this.errorMessage.style.display = "block";
			this.errorMessage.innerHTML = data.error;
		}
	}
}
new ThemeImporter();