import Endpoints from "../../Endpoints.js";

class EnableButton{

	button = document.querySelector("#enable-account-button");
	accountID = parseInt(document.querySelector("#account-id").value);
	isProcessing = false;

	constructor(){
		if (this.button) {
			this.button.addEventListener("click", () => {
				this.onClick();
			});
		}
	}

	async onClick(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;

		const fData = new FormData();
		fData.set("is-disabled", "0");

		const response = await fetch(`${Endpoints.userAccounts.changeDisabledStatus}/${this.accountID}/disabled`, {
		    body:fData,
		    method:"PATCH",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		let data;
		try{
		    /** @type {{status: int, error: ?string}} **/
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
			this.isProcessing = false;
		    return;
		}

		if (data.status === 1){
			window.location.reload();
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
	}
}

export default new EnableButton();