import Endpoints from "../../Endpoints.js";

class EditAccountForm {
	form = document.querySelector("#edit-user-form");
	submitButton = this.form.querySelector(`button[type="submit"]`);
	accountID = parseInt(document.querySelector("#account-id").value);
	isProcessing = false;

	constructor(){
		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.submitButton.classList.add("disabled");

		const response = await fetch(`${Endpoints.userAccounts.editAccount}/${this.accountID}`, {
		    body:new FormData(this.form),
		    method:"PATCH",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		let data;
		try{
			/** @type {{status: int, error: ?string}} */
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
			this.isProcessing = false;
			this.submitButton.classList.remove("disabled");
			return;
		}

		if (data.status === 1){

		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
		this.submitButton.classList.remove("disabled");
	}
}

export default new EditAccountForm();