import Tooltip from "../../_external/bootstrap/tooltip.js";
import Endpoints from "../../Endpoints.js";
import NewPasswordModal from "../modals/NewPasswordModal.js";

class NewPasswordForm {
	form = document.querySelector("#new-password-form");
	formContainer = document.querySelector("#new-password-change-form-container");
	changedNotificationContainer = document.querySelector("#new-password-changed-notification");
	passwordField = this.form.querySelector("#new-account-password");
	viewPasswordButton = this.form.querySelector("#view-password-button");
	accountID = parseInt(document.querySelector("#account-id").value);
	isProcessing = false;

	constructor(){
		new Tooltip(this.viewPasswordButton);
		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});

		this.viewPasswordButton.addEventListener("mousedown", e => {
			this.onViewPasswordMouseDown();
		});

		window.addEventListener("mouseup", e => {
			this.onWindowMouseUp();
		});
	}

	onViewPasswordMouseDown(){
		this.passwordField.setAttribute("type", "text");
	}

	onWindowMouseUp(){
		if (this.passwordField.getAttribute("type") === "text") {
			this.passwordField.setAttribute("type", "password");
		}
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;

		const response = await fetch(`${Endpoints.userAccounts.changePassword}/${this.accountID}/password`, {
		    body:new FormData(this.form),
		    method:"PATCH",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		let data;
		try{
			/** @type {{status: int, error: ?string}} */
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
			this.isProcessing = false;
			return;
		}

		if (data.status === 1){
			// Password changed successfully.
			// Show the success message
			this.formContainer.style.display = "none";
			this.changedNotificationContainer.style.display = "block";

			// Wait for the Bootstrap modal to hide
			await new Promise(resolve => {
				NewPasswordModal.modal.addEventListener("hide.bs.modal", () => {
					resolve(); // Resolve promise, releasing the "await" hold
				}, {
					once: true // Fire this event connection only once
				});
			});

			// It's hidden, reset the change notification message and show the form again
			// in case it's opened again before page reload
			this.formContainer.style.display = "block";
			this.changedNotificationContainer.style.display = "none";
			this.form.reset();
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
	}
}

export default new NewPasswordForm();