import BSTooltip from "../../_external/bootstrap/tooltip.js";
import Endpoints from "../../Endpoints.js";
import NewUserModal from "../modals/NewUserModal.js";
import UserAccounts from "../UserAccounts.js";

class NewUserForm {
	form = document.querySelector("#new-user-form");
	viewPasswordIcon = document.querySelector("#new-account-password-viewer-icon");
	isPasswordViewable = false;
	passwordInputField = this.form.querySelector("#new-account-password");
	isProcessing = false;

	constructor(){

		new BSTooltip(this.viewPasswordIcon);

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});

		this.viewPasswordIcon.addEventListener("mousedown", () => {
			this.onPasswordIconMouseDown();
		});

		window.addEventListener("mouseup", () => {
			this.onWindowMouseUp();
		});
	}

	onPasswordIconMouseDown(){
		if (!this.isPasswordViewable){
			this.isPasswordViewable = true;
			this.passwordInputField.setAttribute("type", "text");
		}
	}

	onWindowMouseUp(){
		if (this.isPasswordViewable){
			this.isPasswordViewable = false;
			this.passwordInputField.setAttribute("type", "password");
		}
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;

		const response = await fetch(`${Endpoints.userAccounts.newAccount}`, {
		    body:new FormData(this.form),
		    method:"PUT",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		let data;
		try{
			/** @type {{status: int, error: ?string}} */
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
			return;
		}

		if (data.status === 1){
			this.form.reset();
			NewUserModal.hideModal();
			UserAccounts.loadAccounts(
				UserAccounts.currentPage,
				UserAccounts.currentLimit,
				UserAccounts.currentQuery
			);
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
	}
}

export default new NewUserForm();