import UserAccounts from "../UserAccounts.js";

class SearchUsersForm {
	constructor(){
		this.isProcessing = false;
		this.form = document.querySelector("#user-search-form");

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;

		const fData = new FormData(this.form);
		const query = fData.get("query");

		UserAccounts.currentPage = 1;
		UserAccounts.currentQuery = query;
		await UserAccounts.loadAccounts(
			UserAccounts.currentPage,
			UserAccounts.currentLimit,
			UserAccounts.currentQuery
		);

		this.isProcessing = false;
	}
}

export default new SearchUsersForm();