export class BaseComponent{
    protected Dom: HTMLElement;

    public Build(): this{
        throw "Not implemented";
    }

    public RenderInto(container: HTMLElement): this{
        container.append(this.Dom);
        return this;
    }

    public Remove(): this{
        this.Dom.remove();
        return this;
    }

    public GetDom(): HTMLElement{
        return this.Dom;
    }

}