export default class NoServiceKeyword {
    public projectDescriptionTextField: HTMLTextAreaElement = document.querySelector("#project-description-input");
    public alertBox: HTMLElement = document.querySelector("#no-service-keyword-warning");
    public alertBoxSelectedPrimaryServiceText: HTMLSpanElement = document.querySelector("#primary-service-text");
    public servicePageInput: HTMLSelectElement = document.querySelector("#service-page-id-input");

    constructor() {
        this.projectDescriptionTextField.addEventListener("input", () => {
            this.onProjectDescriptionInput();
        });

        this.servicePageInput.addEventListener("change", () => {
            this.onServicePageSelectMenuChanged();
        });
    }

    onProjectDescriptionInput(){
        const servicePageName: string | null = this.getServicePageName();
        if (servicePageName !== null){
            // Find this key phrase in the content
            if (this.doesProjectDescriptionIncludeText(servicePageName)){
                // We're good
                this.hideWarning();
            }else{
                // Warn them
                this.showWarning();
            }
        }
    }

    onServicePageSelectMenuChanged(){
        this.onProjectDescriptionInput();
    }

    /**
     * Fetches the name of the selected service page, if any.
     */
    getServicePageName(): string | null{
        const pageID: number = parseInt(this.servicePageInput.value);
        if (pageID > 0){
            return this.getServiceNameFromSelectMenu();
        }else{
            return null;
        }
    }

    doesProjectDescriptionIncludeText(textToCheckFor: string): boolean{
        return this.projectDescriptionTextField.value.toLowerCase().includes(textToCheckFor.toLowerCase());
    }

    getServiceNameFromSelectMenu(): string{
        return this.servicePageInput.options[this.servicePageInput.selectedIndex].textContent;
    }

    showWarning(){
        this.alertBoxSelectedPrimaryServiceText.textContent = this.getServiceNameFromSelectMenu().trim();
        this.alertBox.style.display = null;
    }

    hideWarning(){
        this.alertBox.style.display = "none";
    }
}