export class EndpointsProvider {

    private static BackEndStub: string = "/uplift";
    private static ApiStub: string = `${EndpointsProvider.BackEndStub}/api/private`;
    private static ActiveVersionStub: string = `/v1`;

    public static EndPoints = {
        ActivityLogs: `${EndpointsProvider.BackEndStub}/activity-logs`,
        ApacheManager: {
            EditHtAccess: `${EndpointsProvider.BackEndStub}/htaccess`,
            GetHtAccess: `${EndpointsProvider.BackEndStub}/htaccess`,
        },
        EasyEditor: {
            GetPhoneAndFaxNumbers: `${EndpointsProvider.BackEndStub}/easy-editor/phone-and-fax-numbers`,
            GetPages: `${EndpointsProvider.BackEndStub}/easy-editor/pages`,
            SavePage: `${EndpointsProvider.BackEndStub}/easy-editor/save-page`,
        },
        Galleries: {
            FetchGalleries: `${EndpointsProvider.BackEndStub}/gallery-manager/galleries`,
            NewGallery: `${EndpointsProvider.BackEndStub}/gallery-manager/gallery`,
            RenameGallery: `${EndpointsProvider.BackEndStub}/gallery-manager/gallery`,
            DeleteGallery: `${EndpointsProvider.BackEndStub}/gallery-manager/gallery`,
            FetchGalleryMembers: `${EndpointsProvider.BackEndStub}/gallery-manager/gallery`,
            AddMembersToGallery: `${EndpointsProvider.BackEndStub}/gallery-manager/gallery`,
            UpdateGalleryMembersPositions: `${EndpointsProvider.BackEndStub}/gallery-manager/gallery`,
            UpdateGalleryMemberAltText: `${EndpointsProvider.BackEndStub}/gallery-manager/gallery`,
        },
        ImageManager: {
            FetchImageDirectories: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/image-manager/fetch-directories-recursively`,
            FetchImagesInDirectory: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/image-manager/fetch-directory-images`,
            MoveImage: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/image-manager/move-image`,
            RenameImage: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/image-manager/rename-image-file`,
            ResizeImage: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/image-manager/resize-image`,
            CropImage: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/image-manager/crop-image`,
            UploadImageFile: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/image-manager/upload-image-file`,
            UploadImageByUrlSource: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/image-manager/upload-image-by-url-source`,
            CloneImage: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/image-manager/clone-image`,
            NewDirectory: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/image-manager/new-directory`,
            RenameDirectory: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/image-manager/rename-directory`,
            DeleteDirectory: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/image-manager/delete-directory`,
            MoveDirectory: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/image-manager/move-directory`,
            RegenThumb: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/image-manager/regenerate-thumb`,
            DeleteImage: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/image-manager/delete-image`,
        },
        Login: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/login`,
        PageEditor: {
            Editor: `${EndpointsProvider.BackEndStub}/page-editor`,
            CreateBlankPage: `${EndpointsProvider.BackEndStub}/page-editor/page`,
            GetListOfPages: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/pages`,
            ConvertPageType: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/page-type`,
            DeletePage: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}}/page-editor/page`,
            ClonePage: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/clone-page`,
            NewBlogCategory: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/article-category`,
            RenameBlogCategory: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/article-category`,
            DeleteBlogCategory: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/article-category`,
            SaveBlogCategoryToPage: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/article-category`,
            RelabelProjectTag: `/fbm-core/Controllers/PageEditor/RelabelProjectTag.php`,
            GetGalleries: `/fbm-core/Controllers/ImageGallery/GetGalleries.php`,
            SaveGeneral: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}}/page-editor/save-general`,
            SaveService: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/save-service`,
            SaveBlog: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/save-blog`,
            SaveProject: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/save-project`,
            SaveCity: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/save-city`,
            NewProjectTag: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/project-tag`,
            RenameProjectTag: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/project-tag`,
            DeleteProjectTag: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/project-tag`,
            SaveProjectTagToPageId: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/project-tag`,
            RemoveProjectTagIdFromPageId: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/page-editor/project-tag`,
        },
        Redirects: {
            NewRedirect: `${EndpointsProvider.BackEndStub}/redirects`,
            EditRedirect: `${EndpointsProvider.BackEndStub}/redirect`,
            DeleteRedirect: `${EndpointsProvider.BackEndStub}/redirect`,
            GetRedirects: `${EndpointsProvider.BackEndStub}/redirects`,
        },
        Reviews: {
            GetReviews: `${EndpointsProvider.BackEndStub}/reviews`,
            NewReview: `${EndpointsProvider.BackEndStub}/reviews`,
            DeleteReview: `${EndpointsProvider.BackEndStub}/review`,
            EditReview: `${EndpointsProvider.BackEndStub}/review`,
        },
        Roles: {
            GetRoles: `${EndpointsProvider.BackEndStub}/roles`,
            NewRole: `${EndpointsProvider.BackEndStub}/roles`,
            EditRole: `${EndpointsProvider.BackEndStub}/roles`,
            DeleteRole: `${EndpointsProvider.BackEndStub}/roles`,
        },
        Settings: {
            SaveCompanyInformation: `${EndpointsProvider.BackEndStub}/save-company-information`,
            SaveUpliftSettings: `${EndpointsProvider.BackEndStub}/save-uplift-settings`,
            SaveContentSettings: `${EndpointsProvider.BackEndStub}/save-content-settings`,
            EditRobotSettings: `${EndpointsProvider.BackEndStub}/robots`,
        },
        SitemapManager: {
            GetSitemaps: `${EndpointsProvider.BackEndStub}/sitemaps`,
            NewSitemap: `${EndpointsProvider.BackEndStub}/sitemaps`,
            EditSitemap: `${EndpointsProvider.BackEndStub}/sitemaps`,
            DeleteSitemap: `${EndpointsProvider.BackEndStub}/sitemaps`,
        },
        ThemeEditor: {
            GetDirectoryContents: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/template-manager/theme/list-directory`,
            DeleteThemeDirectory: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/template-manager/theme/delete-directory`,
            NewThemeDirectory: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/template-manager/theme/new-directory`,
            RenameThemeDirectory: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/template-manager/theme/rename-directory`,
            NewThemeFile: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/template-manager/theme/new-file`,
            SaveThemeFile: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/template-manager/theme/save-file`,
            RenameThemeFile: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/template-manager/theme/rename-file`,
            GetThemeFileContents: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/template-manager/theme/file-contents`,
            DeleteThemeFile: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/template-manager/theme/delete-file`,
            CompileSCSSFile: `${EndpointsProvider.ApiStub}${EndpointsProvider.ActiveVersionStub}/template-manager/theme/compile-scss-file`,
        },
        UserAccounts: {
            GetAccounts: `${EndpointsProvider.BackEndStub}/user-accounts`,
            NewAccount: `${EndpointsProvider.BackEndStub}/user-accounts`,
            EditAccount: `${EndpointsProvider.BackEndStub}/user-accounts`,
            ChangePassword: `${EndpointsProvider.BackEndStub}/user-accounts`,
            ChangeDisabledStatus: `${EndpointsProvider.BackEndStub}/user-accounts`
        }
    }
}