import { PageResult } from "./Components/PageResult";
import { FileResult } from "./Components/FileResult";
import { Scheduler } from "../Utils/Scheduler";
import { SearchForm } from "./Forms/SearchForm";
import { ReplaceForm } from "./Forms/ReplaceForm";

export class FindAndReplace{
    public ReplaceAllLoaderContainer: HTMLElement | null = document.querySelector("#replacing-all-loader");
    public MainAppContainer: HTMLElement | null = document.querySelector("#main-application-container");
    public ReplaceAllOccurrencesButton: HTMLButtonElement | null = document.querySelector("#replace-all-occurrences-button");
    public SearchForm: SearchForm;
    public ReplaceForm: ReplaceForm;
    public CurrentPageResults: PageResult[] = [];
    public CurrentFileResults: FileResult[] = [];
    /**
     * The last query used in a search. This is populated in the SearchForm when
     * a find request is made.
     */
    public LastQueryUsed: string = undefined;

    public constructor(){
        this.SearchForm = new SearchForm(this);
        this.ReplaceForm = new ReplaceForm(this);
    }
}

new FindAndReplace();