import { EndpointsProvider } from "../../EndpointsProvider";
import { ManageRedirects } from "../ManageRedirects";

export class NewRedirectForm{
    private Form = document.querySelector<HTMLFormElement>("#new-redirect-form");
    private IsProcessing: boolean = false;
	private ManageRedirectsInstance: ManageRedirects;

    public constructor(manageRedirectsInstance: ManageRedirects){
		this.ManageRedirectsInstance = manageRedirectsInstance;
        this.Form.addEventListener("submit", e => {
			e.preventDefault();
			this.OnSubmit();
		});
    }
	/**
	 * Sends form data to the server and updates within the UI
	 * @returns 
	 */
    private async OnSubmit(){
        if (this.IsProcessing){
			return;
		}

		this.IsProcessing = true;

		const response = await fetch(`${EndpointsProvider.EndPoints.Redirects.NewRedirect}`, {
		    body:new FormData(this.Form),
		    method:"PUT",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		let data: {status: number, error?: string};
		try{
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
			return;
		}

		if (data.status === 1){
			this.Form.reset();
			this.ManageRedirectsInstance.NewRedirectModal.HideModal();
			this.ManageRedirectsInstance.LoadRedirects(
				this.ManageRedirectsInstance.CurrentPage,
				this.ManageRedirectsInstance.CurrentLimit,
				this.ManageRedirectsInstance.CurrentQuery
			);
		}else if (data.status === -1){
			alert(data.error);
		}

		this.IsProcessing = false;
    }
}