import { ManageRedirects } from "../ManageRedirects";

export class SearchRedirectsForm{
    private Form = document.querySelector<HTMLFormElement>("#redirect-search-form");
    private IsProcessing: boolean = false;
	private ManageRedirectsInstance: ManageRedirects;

    public constructor(manageRedirectsInstance: ManageRedirects){
		this.ManageRedirectsInstance = manageRedirectsInstance;
        this.IsProcessing = false;
		this.Form = document.querySelector("#redirect-search-form");

		this.Form.addEventListener("submit", e => {
			e.preventDefault();
			this.OnSubmit();
		});
    }
	/**
	 * Handles the "search" within the form
	 * @returns 
	 */
    private async OnSubmit(): Promise<void>{
        if (this.IsProcessing){
			return;
		}

		this.IsProcessing = true;

		const fData = new FormData(this.Form);
		const query = (fData.get("query") as string) || "";
		this.ManageRedirectsInstance.CurrentPage = 1;
		this.ManageRedirectsInstance.CurrentQuery = query;
		await this.ManageRedirectsInstance.LoadRedirects(
			this.ManageRedirectsInstance.CurrentPage,
			this.ManageRedirectsInstance.CurrentLimit,
			this.ManageRedirectsInstance.CurrentQuery
		);

		this.IsProcessing = false;
    }
}