export class RatingStars {

	private EventListeners = [];
	private Stars: HTMLElement[];
	public ParentElement: HTMLDivElement;

	/**
	 * @param {HTMLDivElement} parentElement
	 */
	constructor(parentElement: HTMLDivElement) {

		this.EventListeners = [];
		this.Stars = Array.from(parentElement.querySelectorAll("i"));
		this.ParentElement = parentElement;
		parentElement.setAttribute("rating", "0");

		for (const star of this.Stars) {

			star.addEventListener("mouseover", e => {
				e.stopPropagation();
				this.OnStarHovered(star);
			});

			star.addEventListener("click", () => {

				parentElement.setAttribute("rating", String(this.Stars.indexOf(star) + 1));
				for (const callback of this.EventListeners) {
					/**
					 * Fire the event listener callbacks.
					 */
					callback(this.Stars.indexOf(star) + 1);
				}

			});
		}

		parentElement.addEventListener("mouseleave", () => {
			this.HighlightToRating(parentElement.getAttribute("rating"));
		});

	}

	public HighlightToRating(rating) {
		/**
		 * Remove color from all stars.
		 */
		for (const star of this.Stars) {

			if (star.classList.contains("colored")) {
				star.classList.remove("colored");
			}
		}

		if (rating > 0) {
			let currentStar: HTMLElement = this.Stars[rating - 1];
			/**
			 * Color current star and previous ones.
			 */
			do {
				currentStar.classList.add("colored");
				currentStar = currentStar.previousElementSibling as HTMLElement;
			}

			while (currentStar !== null);
		}
	}

	/**
	 * When the mouse goes over a star.
	 * @param {HTMLElement} currentStar
	 */
	public OnStarHovered(currentStar) {
		this.HighlightToRating(this.Stars.indexOf(currentStar) + 1);
	}

	public OnStarSelected(callback) {
		this.EventListeners.push(callback);
	}
}