import { BaseComponent } from "../../Bases/BaseComponent";
import { IReview } from "../../Interfaces/ManageReviews/IReview";
import { ManageReviews } from "../ManageReviews";
import { EditReviewModal } from "../Modals/EditReviewModal";

export class Review extends BaseComponent{

	public ReviewObject: IReview;
	private ManageReviewsInstance: ManageReviews;
	private EditReviewModalInstance: EditReviewModal;

	public constructor(
		reviewObject: IReview,
		manageReviewsInstance: ManageReviews,
		editReviewModalInstance: EditReviewModal
	){
		super();
		this.ReviewObject = reviewObject;
		this.ManageReviewsInstance = manageReviewsInstance;
		this.EditReviewModalInstance = editReviewModalInstance;
	}

	public override Build(): this{
		const humanDate = new Date(this.ReviewObject.postedTimestamp * 1000);
		let locationString = "";
		let authorString = "";
		
		if (this.ReviewObject.city.length === 0){
			// No city, check if there is a state.
			if(this.ReviewObject.state.length > 0){
				locationString = this.ReviewObject.state;
			}
		}
		else{
			// There is a city, check if there is a state.
			if (this.ReviewObject.state.length > 0){
				locationString = `${this.ReviewObject.city}, ${this.ReviewObject.state}`;
			}else{
				locationString = this.ReviewObject.city;
			}
		}

		if (this.ReviewObject.lastName.length === 0){
			// No last name, check for first name.
			if(this.ReviewObject.firstName.length > 0){
				authorString = this.ReviewObject.firstName;
			}
		}
		else{
			// There is a last name, check for first name.
			if (this.ReviewObject.firstName.length > 0){
				authorString = `${this.ReviewObject.firstName} ${this.ReviewObject.lastName}`;
			}else{
				authorString = this.ReviewObject.lastName;
			}
		}

		const template = document.createElement("div");
		template.classList.add("review-info-row");
		template.classList.add("review-columns");
		template.innerHTML = `
			<div class="review-date">${humanDate.toLocaleDateString()}</div>
			<div class="location-name">${locationString}</div>
			<div class="rating-row">
				<div class="row-stars">
				</div>
				<span id="rating-number" class="rating-number">${this.ReviewObject.rating.toFixed(1)}</span>
			</div>
			<div class="review-author-name">${authorString}</div>
			<div class="review-body">${this.ReviewObject.body}</div>
			<div class="management-buttons">
				<button type="button" class="edit-button">
					<i class="bi bi-pencil-square"></i>
				</button>
				<button type="button" class="delete-button">
					<i class="bi bi-trash3"></i>
				</button>
			</div>
		`;

		template.querySelector(".delete-button").addEventListener("click", () => {
			this.ManageReviewsInstance.DeleteReviewModal.ReviewComponent = this;
			this.ManageReviewsInstance.DeleteReviewModal.Show();
		});

		template.querySelector(".edit-button").addEventListener("click", () => {
			this.EditReviewModalInstance.ReviewComponent = this;
			this.EditReviewModalInstance.LoadReview();
			this.EditReviewModalInstance.Show();
		});

		for(let i = 0; i < this.ReviewObject.rating; i++){
			const icon = document.createElement("i");
			icon.classList.add("bi");
			icon.classList.add("bi-star-fill");
			template.querySelector<HTMLElement>(".row-stars").append(icon);
		}

		this.Dom = template;
		return this;
	}
}