import { EndpointsProvider } from "../../EndpointsProvider";
import { NewReviewModal } from "../Modals/NewReviewModal";
import { ManageReviews } from "../ManageReviews";

export class NewReviewForm {

	private ManageReviewsInstance: ManageReviews;
	private NewReviewModalInstance: NewReviewModal;
	public IsProcessing: boolean = false;
	public Form: HTMLFormElement;

	constructor() {
		this.IsProcessing = false;
		this.Form = document.querySelector("#new-review-form");
		/**
		 * Form submission event listener. 
		 */
		this.Form.addEventListener("submit", e => {
			e.preventDefault();
			this.OnSubmit();
		})
	}

	public async OnSubmit() {

		if (this.IsProcessing) {
			return;
		}

		this.IsProcessing = true;

		const fData = new FormData(this.Form);
		/**
		 * Sends new review request. 
		 */
		const response = await fetch(EndpointsProvider.EndPoints.Reviews.NewReview, {
			credentials: "same-origin",
			cache: "no-cache",
			body: fData,
			method: "PUT"
		});

		let data;
		try {
			data = await response.json();
		} catch (jsonSyntaxError) {
			this.IsProcessing = false;
			return;
		}

		if (data.status === 1) {
			/**
			 * Reload all reviews if submission successsful. 
			 */
			this.ManageReviewsInstance.CurrentPage = ManageReviews.DEFAULT_PAGE;
			this.ManageReviewsInstance.CurrentLimit = ManageReviews.DEFAULT_LIMIT;
			this.ManageReviewsInstance.CurrentQuery = "";
			this.ManageReviewsInstance.LoadReviews(
				this.ManageReviewsInstance.CurrentPage,
				this.ManageReviewsInstance.CurrentLimit,
				this.ManageReviewsInstance.CurrentQuery,
			);

			this.Form.reset();
		}
		/**
		 * Handles submission error. 
		 */
		else if (data.status === -1) {
		}

		this.IsProcessing = false;
	}
}