import { BaseModal } from "../../Bases/BaseModal";
import { Scheduler } from "../../Utils/Scheduler";
import { ManageReviews } from "../ManageReviews";
import { Review } from "../Components/Review";

export class EditReviewModal extends BaseModal{

    private LastRatingClickedOn = 5;
    private ManageReviewsInstance: ManageReviews;
    public ReviewComponent: Review;

    public constructor(manageReviewsInstance: ManageReviews){
        super();
        this.ManageReviewsInstance = manageReviewsInstance;
    }

    public override Build(): this {
        const template = document.createElement("div");
        template.classList.add("modal");
        template.setAttribute("id", "edit-review-modal");
        template.innerHTML = `
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h2 class="modal-title h4 mb-0">Edit Existing Review</h2>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form id="edit-review-form">
                            <p>
                                Please review and update the information below, or select 'Cancel' if no changes are needed.
                            </p>
                            <hr>
                            <div>
                                <div class="container-fluid">
                                    <div class="row">
                                        <div class="col-xl-6">
                                            <label for="edit-review-first-name">First name</label>
                                            <input type="text" class="form-control" name="first-name" id="edit-review-first-name">
                                        </div>
                                        <div class="col-xl-6">
                                            <label for="edit-review-last-name">Last name</label>
                                            <input type="text" class="form-control" name="last-name" id="edit-review-last-name">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xl-6">
                                            <label for="edit-review-city">City</label>
                                            <input type="text" class="form-control" name="city" id="edit-review-city">
                                        </div>
                                        <div class="col-xl-6">
                                            <label for="edit-review-state">State</label>
                                            <input type="text" class="form-control" name="state" id="edit-review-state">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col">
                                            <label for="edit-review-body">Testimonial</label>
                                            <textarea class="review-body-input form-control" id="edit-review-body" name="body"></textarea>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col">
                                            <div class="rating-label">
                                                <label>Overall Testimonial Rating</label>
                                                <p>Click to select rating</p>
                                            </div>
                                            <input type="hidden" class="form-control" name="rating" id="edit-review-rating">
                                            <div>
                                                <div id="edit-review-rating-stars">
                                                    <button type="button" class="star-buttons active" data-rating="1">
                                                        <span><i class="bi bi-star-fill"></i></span>
                                                    </button>
                                                    <button type="button" class="star-buttons active" data-rating="2">
                                                        <span><i class="bi bi-star-fill"></i></span>
                                                    </button>
                                                    <button type="button" class="star-buttons active" data-rating="3">
                                                        <span><i class="bi bi-star-fill"></i></span>
                                                    </button>
                                                    <button type="button" class="star-buttons active" data-rating="4">
                                                        <span><i class="bi bi-star-fill"></i></span>
                                                    </button>
                                                    <button type="button" class="star-buttons active" data-rating="5">
                                                        <span><i class="bi bi-star-fill"></i></span>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="edit-review-modal-error" class="row" style="display:none;">
                                        <div class="col alert alert-danger" style="border-radius: 4px;">
                                            <div></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <hr></hr>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <span>Cancel</span>
                        </button>
                        <button form="edit-review-form" type="submit" class="btn btn-primary" id="save-changes-button">
                            <span id="save-changes-button-text">Save Changes</span>
                            <span id="save-changes-button-spinner" class="spinner-border spinner-border-sm" role="status" aria-hidden="true" style="display: none;"></span>
                            <i id="save-changes-button-icon" class="bi bi-save"></i>
                        </button>
                    </div>
                </div>
            </div> 
        `;
        this.Modal = template;
        this.BSModal = new bootstrap.Modal(template);

        const form = template.querySelector<HTMLFormElement>("#edit-review-form");
        const starButtons = template.querySelectorAll<HTMLButtonElement>(".star-buttons");

        form.addEventListener("submit", (e) => {
            e.preventDefault();
            this.OnFormSubmitted();
        });

        for(const starButton of Array.from(starButtons)){
            starButton.addEventListener("click", () => {
                this.OnStarButtonClicked(starButton);
            });
        }

        this.Modal.addEventListener('hidden.bs.modal', () => {
            this.ResetForm();
        });

        return this;
    }

    public LoadReview(): void {
        const reviewData = this.ReviewComponent.ReviewObject;

        this.Modal.querySelector<HTMLInputElement>("#edit-review-first-name").value = reviewData.firstName;
        this.Modal.querySelector<HTMLInputElement>("#edit-review-last-name").value = reviewData.lastName;
        this.Modal.querySelector<HTMLInputElement>("#edit-review-city").value = reviewData.city;
        this.Modal.querySelector<HTMLInputElement>("#edit-review-state").value = reviewData.state;
        this.Modal.querySelector<HTMLTextAreaElement>("#edit-review-body").value = reviewData.body;
        this.Modal.querySelector<HTMLInputElement>("#edit-review-rating").value = reviewData.rating.toString();

        for (let i = 1; i <= 5; i++) {
            const currentButton = this.Modal.querySelector<HTMLButtonElement>(`.star-buttons[data-rating="${i}"]`);
            if (i <= reviewData.rating) {
                currentButton.classList.add("active");
            } else {
                currentButton.classList.remove("active");
            }
        }
    }

    private OnStarButtonClicked(starButton: HTMLButtonElement): void{

        const rating = parseInt(starButton.getAttribute("data-rating"));
        this.LastRatingClickedOn = rating;

        for(let i = 1; i <= 5; i++){
            const currentButton = this.Modal.querySelector<HTMLButtonElement>(`.star-buttons[data-rating="${i}"]`);
            if(i <= rating){
                currentButton.classList.add("active");
            }else{
                currentButton.classList.remove("active");
            }
        }
    }

    private async OnFormSubmitted(): Promise<void>{
        
        const saveButton = this.Modal.querySelector<HTMLButtonElement>("#save-changes-button");
        const saveButtonSpinner = this.Modal.querySelector<HTMLSpanElement>("#save-changes-button-spinner");
        const saveButtonText = this.Modal.querySelector<HTMLSpanElement>("#save-changes-button-text");
        const saveButtonIcon = this.Modal.querySelector<HTMLElement>("#save-changes-button-icon");

        saveButton.disabled = true;
        saveButtonSpinner.style.display = "inline-block";
        saveButtonText.textContent = "Loading...";
        saveButtonIcon.style.display = "none";

        const payload = {
            "first-name": this.Modal.querySelector<HTMLInputElement>("#edit-review-first-name").value,
            "last-name": this.Modal.querySelector<HTMLInputElement>("#edit-review-last-name").value,
            "city": this.Modal.querySelector<HTMLInputElement>("#edit-review-city").value,
            "state": this.Modal.querySelector<HTMLInputElement>("#edit-review-state").value,
            "body": this.Modal.querySelector<HTMLTextAreaElement>("#edit-review-body").value,
            "rating": this.LastRatingClickedOn
        };
        
        const response: Response = await fetch(`/uplift/review/${this.ReviewComponent.ReviewObject.id}`, {
            method: "PATCH",
            body: JSON.stringify(payload),
            headers: new Headers({
                "content-type": "application/json"
            })
        });

        await Scheduler.Wait(700);
        const apiResponse = await response.json();
        
        if("error" in apiResponse){
            const errorContainer = this.Modal.querySelector<HTMLDivElement>("#edit-review-modal-error");
            const errorMessage = apiResponse.error;

            errorContainer.style.display = null;
            errorContainer.querySelector("div").textContent = errorMessage;

        } else{
            this.ResetForm();
            this.Hide();
            this.ManageReviewsInstance.LoadReviews();
        }

        saveButton.disabled = false;
        saveButtonSpinner.style.display = "none";
        saveButtonIcon.style.display = "inline-block";
        saveButtonText.textContent = "Add a Review";
    
    }
    
    private ResetForm(): void {
        const form = this.Modal.querySelector<HTMLFormElement>("#edit-review-form");
        const errorContainer = this.Modal.querySelector<HTMLDivElement>("#edit-review-modal-error");
        form.reset();
        this.LastRatingClickedOn = 5;
        errorContainer.style.display = "none";

        for (let i = 1; i <= 5; i++) {
            const starButton = this.Modal.querySelector<HTMLButtonElement>(`.star-buttons[data-rating="${i}"]`);
            
            if(i <= 5){
                starButton.classList.add("active");
            } else{
                starButton.classList.remove("active");
            }
        }
    }
}