import { EndpointsProvider } from "../../EndpointsProvider";
import { NewRoleModal } from "../List/Modals/NewRoleModal";
import { Role } from "../List/Components/Role";
import { Scheduler } from "../../Utils/Scheduler";
import { IRole } from "../../Interfaces/ManageRoles/IRole";
import { NewRoleForm } from "./Forms/NewRoleForm";

export class Roles{
    private LoaderElement = document.querySelector<HTMLElement>("#roles-loader");
	public NewRoleModal: NewRoleModal = new NewRoleModal();
	public NewRoleForm: NewRoleForm;

    public constructor(){
		this.NewRoleForm = new NewRoleForm(this);
        (async () => {
			this.LoadRoles();
		})();
    }

	/**
	 * Fetches list of roles from the server and updates the page with new roles
	 * @returns {Promise<void>}
	 */
    public async LoadRoles(): Promise<void>{
        // Clear current roles
		Role.RolesContainer.innerHTML = "";

		// Show loader
		this.LoaderElement.style.display = "block";

		const response = await fetch(`${EndpointsProvider.EndPoints.Roles.GetRoles}`, {
			body:null,
			cache:"no-cache",
			credentials:"same-origin"
		});

		let data: {status: number, error?: string, roles?: IRole[]};
		try{
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
		}

		// Force-wait a minimum of 0.15s so things don't flash
		await Scheduler.Wait(150);

		// Hide loader
		this.LoaderElement.style.display = "none";
		
		if (data.status === 1){
			for (const role of data.roles){
				new Role(
					role.id,
					role.name,
					role.canBeDeleted,
					role.timestamp,
				);
			}
		}else if (data.status === -1){
			console.log("Something went wrong.");
		}
    }
}

new Roles();