export class HasAllPermsCheckbox{
    public Checkbox = document.querySelector<HTMLInputElement>("#all-perms-input");

    public constructor(){
        if (this.Checkbox) {
            this.Checkbox.addEventListener("change", () => {
                this.CheckboxChanged();
            });

		    this.CheckboxChanged();
        }
    }

    /**
     * Checks if the "all-perms" checkbox is checked and enables/disables
     * @returns {void}
     */
    public CheckboxChanged(): void{
		if (this.Checkbox.checked){
			this.DisableAllPermCheckboxes();
		}else{
			this.EnabledAllPermCheckboxes();
		}
	}

    /**
     * Disables all perm checkboxes
     * @returns {void}
     */
    public DisableAllPermCheckboxes(): void{
        document.querySelectorAll<HTMLInputElement>(".perm-checkbox").forEach((checkbox) => {
            checkbox.setAttribute("disabled", "true");
        });
	}
    
    /**
     * Enables all perm checkboxes
     * @returns {void}
     */
    public EnabledAllPermCheckboxes(): void{
        document.querySelectorAll<HTMLInputElement>(".perm-checkbox").forEach((checkbox) => {
            checkbox.removeAttribute("disabled");
        });
	}
}