import { EndpointsProvider } from "../../../EndpointsProvider";
import { Scheduler } from "../../../Utils/Scheduler";

export class EditRoleForm{
    private Form: HTMLFormElement | null = document.querySelector("#edit-role-form");
    private RoleID: number;
    private SubmitButton: HTMLButtonElement | null = document.querySelector("#edit-role-submit-button");
	private DeleteModalButton: HTMLButtonElement | null = document.querySelector("#delete-role-modal-button");
    private DeleteConfirmButton: HTMLButtonElement | null = document.querySelector("#delete-role-button");
    private IsProcessing: boolean = false;

    public constructor(){
		this.Form = document.querySelector("#edit-role-form");
		if (this.Form) {
			this.RoleID = parseInt((this.Form.querySelector("#role-id") as HTMLInputElement).value);
		}

        this.Form.addEventListener("submit", e => {
			e.preventDefault();
			this.OnSubmit();
		});

        if (this.DeleteModalButton) {
            this.DeleteModalButton.addEventListener("click", e => {
                e.preventDefault();
                const modal = new bootstrap.Modal(document.getElementById("delete-role-modal"));
                modal.show();
            });
        }

		if (this.DeleteConfirmButton) {
            this.DeleteConfirmButton.addEventListener("click", e => {
                e.preventDefault();
                this.OnDelete();
            });
        }
    }
	
    /**
     * Handles form submission - sends PATCH request to update a role
     * @returns 
     */
    public async OnSubmit(): Promise<void>{
        if (this.IsProcessing){
			return;
		}

		this.IsProcessing = true;
		this.SubmitButton.classList.add("disabled");
		this.SubmitButton.querySelector("span").textContent = "Saving...";

		const response = await fetch(`${EndpointsProvider.EndPoints.Roles.EditRole}/${this.RoleID}`, {
			body:new FormData(this.Form),
			method:"PATCH",
			cache:"no-cache",
			credentials:"same-origin"
		});

		let data: {status: number, error?: string};
		try{
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
			this.IsProcessing = false;
			return;
		}

		await Scheduler.Wait(500);

		if (data.status === 1){

		}else if (data.status === -1){
			alert(data.error);
		}

		this.IsProcessing = false;
		this.SubmitButton.classList.remove("disabled");
		this.SubmitButton.querySelector("span").textContent = "Save";
    }

    /**
     * Handles the deletion of a role - sends DELETE request
     * @returns 
     */
   	public async OnDelete(): Promise<void>{
        if (this.IsProcessing){
			return;
		}

		this.IsProcessing = true;

		const response = await fetch(`${EndpointsProvider.EndPoints.Roles.DeleteRole}/${this.RoleID}`, {
			body:new FormData(this.Form),
			method:"DELETE",
			cache:"no-cache",
			credentials:"same-origin"
		});

		let data: {status: number, error?: string};
		try{
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
			this.IsProcessing = false;
			return;
		}

		if (data.status === 1){
			window.location.href = "/uplift/manage-roles";
		}else if (data.status === -1){
			alert(data.error);
		}

		this.IsProcessing = false;
    }
}