import Cookie from "./../../../_external/js.cookie.js";
export default class CreateAccountForm{

    private IsProcessing: boolean = false;
    private Form: HTMLFormElement = document.querySelector<HTMLFormElement>("#new-general-account-form");
    private Loader: HTMLElement = document.querySelector("#form-loader");
    private ButtonsContainer: HTMLElement = document.querySelector("#form-submit-buttons");
    private ErrorContainer: HTMLElement = document.querySelector("#form-error-container");
    private Error: HTMLElement = document.querySelector("#form-error");

    public constructor() {
        this.Form.addEventListener("submit", e => {
           e.preventDefault();
           this.OnFormSubmit();
        });
    }

    private async OnFormSubmit(): Promise<void>{
        if (this.IsProcessing){
            return;
        }

        this.IsProcessing = true;
        this.Loader.style.display = null;
        this.ErrorContainer.style.display = "none";
        this.ButtonsContainer.style.display = "none";
        const response: Response = await fetch(`/uplift/accounts/create-account-from-client-dashboard`, {
            method: "POST",
            body: new FormData(this.Form)
        });

        if (response.status !== 200){
            let apiData: {error: string, status: number};
            try{
                apiData = await response.json();
                this.Error.textContent = apiData.error;
            }catch(jsonError){
                this.Error.textContent = "There was an unexpected error on the server.";
            }

            this.ErrorContainer.style.display = null;
        }else{
            const apiData: {token: string, loginTokenCookieName: string} = await response.json();
            Cookie.set(apiData.loginTokenCookieName, apiData.token, { expires: 30 });
            window.location.href = "/admin-panel";
            return;
        }

        this.Loader.style.display = "none";
        this.ButtonsContainer.style.display = null;
        this.IsProcessing = false;
    }
}