<?php
	/** @var array $viewScope */

	/** @var Account $currentAccount */

	use Accounts\Account;
	use Roles\PermissionCategories;
	use Settings\Setting;
	use Settings\Settings;
	use System\System;

	$currentAccount = $viewScope['account'] ?? null;
	if ($currentAccount === null){
		$currentAccount = Account::getCurrentUser();
	}

	/** @var ?string $coreNeedsUpdating "0" or "1" or null */
	$coreNeedsUpdating = Setting::getSettingValue(Settings::CORE_NEEDS_UPDATING->value);

	$homeMenuItems = [
		[true, "/uplift/dashboard", "Dashboard", "#66CC33", "bi bi-house-fill", "Dashboard"],
	];

	$editMenuItems = [
		[$currentAccount->hasPermission(PermissionCategories::EDIT_PAGES) && $currentAccount->hasPermission(PermissionCategories::ACCESS_PAGE_EDITOR), "/uplift/page-editor", "Create pages", "#66CCFF", "bi bi-pencil-square", "Page Editor"],
		[$currentAccount->hasPermission(PermissionCategories::MANAGE_TEMPLATE_FILES), "/uplift/theme-manager", "Manage Theme Template Files", "#66CCFF", "bi bi-code-square", "Template Manager"],
		[$currentAccount->hasPermission(PermissionCategories::MANAGE_IMAGE_GALLERIES), "/uplift/gallery-manager", "Image Gallery Manager", "#66CCFF", "bi bi-images", "Image Gallery Manager"],
		[$currentAccount->hasPermission(PermissionCategories::EDIT_PAGES) && $currentAccount->hasPermission(PermissionCategories::ACCESS_EASY_EDITOR), "/uplift/easy-editor", "Manage your site's content", "#66CCFF", "bi bi-easel", "Easy Editor"],
		[$currentAccount->hasPermission(PermissionCategories::ACCESS_CLIENT_IPP_FORM) && Setting::getSettingValue(Settings::IPP_FORM_DISABLED->value) !== "1", "/uplift/ipp-form", "Upload project posts conveniently", "#66CCFF", "bi bi-hammer", "Upload IPP Form"]
	];

	$manageMenuItems = [
		[$currentAccount->hasPermission(PermissionCategories::MANAGE_REDIRECTS), "/uplift/manage-redirects", "Manage Redirections", "#FFCC00", "bi bi-signpost-fill", "Redirects"],
		[$currentAccount->hasPermission(PermissionCategories::MANAGE_REVIEWS), "/uplift/manage-reviews", "Manage Reviews", "#FFCC00", "bi bi-star-fill", "Reviews"],
		[$currentAccount->hasPermission(PermissionCategories::VIEW_ACTIVITY_LOGS), "/uplift/view-activity-logs", "View Activity Logs", "#FFCC00", "bi bi-journal-text", "Activity Logs"],
		[$currentAccount->hasPermission(PermissionCategories::MANAGE_SITEMAPS), "/uplift/manage-sitemaps", "Sitemap Manager", "#FFCC00", "bi bi-diagram-3-fill", "Sitemap Manager"],
		[$currentAccount->hasPermission(PermissionCategories::MANAGE_APACHE), "/uplift/manage-apache", "bi bi-server", "#FFCC00", "bi bi-server", "Apache Manager"],
	];

	$accountMenuItems = [
		[$currentAccount->hasPermission(PermissionCategories::MANAGE_USERS), "/uplift/manage-user-accounts", "User account management", "#CC66FF", "bi bi-people-fill", "User Accounts"],
		[$currentAccount->hasPermission(PermissionCategories::MANAGE_ROLES), "/uplift/manage-roles", "Account role manager", "#CC66FF", "bi bi-shield-fill-check", "Role Manager"],
	];

	$toolMenuItems = [
		[$currentAccount->hasPermission(PermissionCategories::WEBSITE_IMPORTER), "/uplift/external-importer", "External website importer", "#FF9933", "bi bi-file-earmark-arrow-down-fill", "External Site Importer"],
		[$currentAccount->hasPermission(PermissionCategories::SENZU_IMPORTER), "/uplift/senzu-importer", "Senzu content importer", "#FF9933", "bi bi-cloud-download-fill", "Senzu Importer"],
		[$currentAccount->hasPermission(PermissionCategories::THEME_IMPORTER), "/uplift/theme-importer", "Theme importer", "#FF9933", "bi bi-brush", "Theme Importer"],
	];

	function renderSidebarLink($item): string
	{
		return "
			<sidebar-link>
				<a href=\"{$item[1]}\" title=\"{$item[2]}\">
					<i style=\"color:{$item[3]};\" class=\"{$item[4]}\"></i>
					<span>{$item[5]}</span>
				</a>
			</sidebar-link>
		";
	}
?>
<aside id="nav-sidebar-container">
	<section id="sidebar-title-section">
		<div class="text-center">
			<img alt="Uplift CMS logo" src="/uplift-assets/images/uplift-logo-white-s.png">
		</div>
	</section>
	<section class="nav-links-section">
		<span class="sidebar-title">Home</span>
		<?php
			foreach($homeMenuItems as $item) {
				if($item[0] === true) {
					echo renderSidebarLink($item);
				}
			}
		?>
	</section>
	<section class="nav-links-section">
		<span class="sidebar-title">Edit</span>
		<?php
			foreach($editMenuItems as $item) {
				if($item[0] === true) {
					echo renderSidebarLink($item);
				}
			}
		?>
	</section>
	<section class="nav-links-section">
		<span class="sidebar-title">Manage</span>
		<?php
			foreach($manageMenuItems as $item) {
				if($item[0] === true) {
					echo renderSidebarLink($item);
				}
			}
		?>
	</section>
	<section class="nav-links-section">
		<span class="sidebar-title">Account</span>
		<?php
			foreach($accountMenuItems as $item) {
				if($item[0] === true) {
					echo renderSidebarLink($item);
				}
			}
		?>
	</section>
	<section class="nav-links-section">
		<span class="sidebar-title">Tools</span>
		<?php
			foreach($toolMenuItems as $item) {
				if($item[0] === true) {
					echo renderSidebarLink($item);
				}
			}
		?>
	</section>
	<section class="nav-links-section">
		<span class="sidebar-title">Settings</span>
		<?php
			if($currentAccount->hasPermission(PermissionCategories::MANAGE_SETTINGS)) {
				?>
				<sidebar-link>
					<a href="/uplift/settings" title="Company & CMS Settings">
						<i style="color:#FF3333;" class="bi bi-gear-wide-connected"></i>
						<span>Settings <?php
							if ($coreNeedsUpdating === "1"){
								?>
								<span id="core-update-sidebar-notification">Update</span>
								<?php
							}
							?>
						</span>
					</a>
				</sidebar-link>
				<?php
			}
		?>
	</section>
	<section class="nav-links-version-section">
		<span>v<?= System::VERSION ?></span>
	</section>
</aside>
