<?php
	use FileSystemUtilities\FSFile;
	use Page\PageType;
	use System\Layouts;
?>
@Layout = "backend-basic.php"
@Head{
	<title>External Website Importer</title>
	<script defer src="/uplift-assets/js/_external/ace-editor/src-min-noconflict/ace.js"></script>
	<script type="module" src="/uplift-assets/js/external-site-importer/ExternalSiteImporter.js"></script>
}
@Body{
	<backend-service-container>
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="card rounded shadow mb-4">
						<div class="card-header">
							<h2 class="mb-0">
								Import an External Webpage &amp; Process It
							</h2>
						</div>
						<div class="card-body">
							<?php include_once __DIR__ . "/_partials/loader.html" ?>
							<?php include_once __DIR__ . "/_partials/success.html" ?>
							<div id="importer-content-body">
								<p>
									This feature allows you to place a URL into the field below and pull the HTML head and body content into their respective editors below. You may add custom filters by editing the filter methods in the <code>src/ExternalSiteImporter/ImportFilters.php</code>.
								</p>
								<div id="loader" class="text-center" style="display:none;">
									<div style="width:5rem; height:5rem;" class="spinner-border" role="status">
										<span class="visually-hidden">Loading...</span>
									</div>
								</div>
								<form id="crawl-form">
									<div>
										<div class="d-flex">
											<div class="flex-grow-1">
												<div class="input-group">
													<div class="input-group-text">
														<i class="bi bi-box-arrow-up-left"></i>
													</div>
													<input type="text" id="import-url-input" name="url" class="form-control" placeholder="Enter a URL">
												</div>
											</div>
											<button type="submit" class="ms-5 px-5 btn btn-primary btn-sm">
												<i class="bi bi-cloud-download-fill"></i>
												<span>Fetch Page</span>
											</button>
										</div>
									</div>
								</form>
								<section id="editors-container" style="display:none;">
									<hr>
									<form id="page-build-form">
										<div id="head-editor" class="importer-editor"></div>
										<div id="body-editor" class="importer-editor"></div>
										<section id="page-data-container" class="mt-3">
											<h3>Page Data</h3>
											<p>
												Here you can define some data about the page should you want to build it from the fetched content as an Uplift page.
											</p>
											<hr>
											<div class="mb-3">
												<label for="page-name-input">Page name</label>
												<div class="input-group">
													<span class="input-group-text"><i class="bi bi-file-earmark-break-fill"></i></span>
													<input type="text" class="form-control" id="page-name-input" name="page-name">
												</div>
											</div>
											<div class="mb-3">
												<label for="page-type-input">Page type</label>
												<div class="input-group">
													<span class="input-group-text"><i class="bi bi-clipboard2-fill"></i></span>
													<select name="page-type" id="page-type-input" class="form-control">
														<?php
															$cases = PageType::cases();
															usort($cases, function(UnitEnum $a, UnitEnum $b){
																return strtolower($a->name) > strtolower($b->name) ? 1 : 0;
															});
															foreach($cases as $case){
																?>
																<option value="<?= $case->name ?>"><?= $case->name ?></option>
																<?php
															}
														?>
													</select>
												</div>
											</div>
											<div id="page-data-city-state-container" class="mb-3" style="display:none;">
												<div class="container-fluid p-0">
													<div class="row">
														<div class="col-xl-5">
															<label for="page-city-name-input">City Name</label>
															<div class="input-group">
																<span class="input-group-text"><i class="bi bi-geo-fill"></i></span>
																<input type="text" class="form-control" id="page-city-name-input" name="page-city-name" placeholder="E.g. Dallas">
															</div>
														</div>
														<div class="col-xl-5">
															<label for="page-state-name-input">Full State/Province Name</label>
															<div class="input-group">
																<span class="input-group-text"><i class="bi bi-geo-fill"></i></span>
																<input type="text" class="form-control" id="page-state-name-input" name="page-state-name" placeholder="E.g. Texas">
															</div>
														</div>
														<div class="col-xl-2">
															<label for="page-state-name-shorthand-input">State/Province Shorthand</label>
															<div class="input-group">
																<span class="input-group-text"><i class="bi bi-geo-fill"></i></span>
																<input type="text" class="form-control" id="page-state-name-shorthand-input" name="page-state-name-shorthand" placeholder="E.g. TX">
															</div>
														</div>
													</div>
													<div id="city-url-input-group-container" class="row">
														<div class="col-12 mt-3">
															<label for="page-city-url-input">City URL</label>
															<div class="input-group">
																<span class="input-group-text"><i class="bi bi-link-45deg"></i></span>
																<input type="text" class="form-control" id="page-city-url-input" name="page-city-url">
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="mb-3">
												<label for="page-route-input">Page route</label>
												<div class="input-group">
													<span class="input-group-text"><i class="bi bi-signpost-fill"></i></span>
													<input type="text" class="form-control" id="page-route-input" name="page-route" placeholder="E.g. /test">
												</div>
											</div>
											<div class="mb-3">
												<label for="page-layout-input">Page layout</label>
												<div class="input-group">
													<span class="input-group-text"><i class="bi bi-grid-1x2-fill"></i></span>
													<select name="page-layout" id="page-layout-input" class="form-control">
														<?php
															$layoutFiles = Layouts::getAvailableLayouts();
															usort($layoutFiles, function(FSFile $a, FSFile $b){
																return strtolower($a->fileNameWithoutExtension) > strtolower($b->fileNameWithoutExtension) ? 1 : 0;
															});
															foreach($layoutFiles as $fsFile){
																?>
																<option value="<?= $fsFile->fileNameWithoutExtension ?>"><?= $fsFile->fileNameWithoutExtension ?></option>
																<?php
															}
														?>
													</select>
												</div>
											</div>
											<div class="card">
												<div class="card-header">
													<h4 class="mb-0">Breadcrumbs</h4>
												</div>
												<div class="card-body">
													<p>
														<button id="add-breadcrumb-button" type="button" class="btn btn-primary btn-sm">
															<i class="bi bi-plus-circle-fill"></i>
															<span>Add Crumb</span>
														</button>
													</p>
													<div id="breadcrumbs-components-container">
													</div>
												</div>
											</div>
										</section>
									</form>
								</section>
							</div>
						</div>
						<div class="card-footer">
							<div class="text-end">
								<button style="display:none;" id="build-page-button" type="submit" class="btn btn-success" form="page-build-form">
									<i class="bi bi-check-circle-fill"></i>
									<span>Build Page</span>
								</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</backend-service-container>
}