@Layout = "backend-basic.php"
@Head{
	<title>Find &amp; Replace</title>
	<script type="module" src="/uplift-core/resources/static/js-out/FindAndReplace/FindAndReplace.js"></script>
}
@Body{
	<backend-service-container>
	<section id="find-and-replace-main">
		<section id="replacing-all-loader" style="display:none;">
			<div class="d-flex justify-content-center align-items-center flex-column">
				<div>
					<div class="spinner-grow text-primary" style="width:6rem; height:6rem;"></div>
				</div>
				<div class="mt-3">
					<h5>Replacing all...</h5>
				</div>
			</div>
		</section>
		<section id="main-application-container">
			<div class="replacement-banner-message-container"></div>
			<div class="card mb-3">
				<div class="card-header">
					<h4>Search Occurrences</h4>
				</div>
				<div class="card-body">
					<div class="content">
						<p>
							This will search for occurrences of a string in page bodies, 
							page heads, and template files in the current theme.
						</p>
						<hr>
						<div class="container-fluid p-0">
							<div class="row g-0">
								<div class="col-12">
									<div class="input-forms-container">
										<form id="search-form">
											<div class="form-group">
												<label for="query-input">Search Query</label>
												<div class="input-group">
													<div class="input-group-text border-end-0">
														<i class="bi bi-search"></i>
													</div>
													<input placeholder="Type your search query" 
														type="text" class="form-control border-start-0" 
														id="query-input" name="query" autocomplete="off">
												</div>
											</div>
										</form>
										<form id="replace-form">
											<div class="form-group">
												<label for="replacement-input">Replacement text</label>
												<div class="input-group">
													<div class="input-group-text border-end-0">
														<i class="bi bi-arrow-repeat"></i>
													</div>
													<input placeholder="Enter a replacement text" 
														type="text" class="form-control border-start-0" 
														id="replacement-input" name="replacement" 
														autocomplete="off">
												</div>
											</div>
										</form>
									</div>
									<div id="replace-form-container" style="display:none;">
										<div class="d-flex justify-content-end">
											<div class="d-flex">
												<button type="submit" form="replace-form" id="replace-all-occurrences-button"
														class="btn btn-primary">
													<span>Replace All Occurrences</span>
													<i class="bi bi-arrow-repeat"></i>
												</button>
											</div>
										</div> 
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="card">
				<div class="results-header">
					<h4>Results</h4>
				</div>
				<div class="card-body">
					<div class="content">
						<div id="results-loader" style="display:none;">
							<div class="d-flex justify-content-center">
								<div style="width:4rem; height:4rem;" 
									 class="spinner-grow text-primary"></div>
							</div>
						</div>
						<div id="no-results-message-container" style="display:none;">
							<em>No results found for your search.</em>
						</div>
						<div id="search-results-container"></div>
					</div>
				</div>
			</div>
		</section>
	</section>
</backend-service-container>
}