@Layout = "backend-basic.php"
@Head{
	<title>Redirects Manager</title>
	<?= \Uplift\Vite\ViteStaticService::Use([
    	new \App\Vite\ViteResource("/uplift-core/resources/static/ts/ManageRedirects/ManageRedirects.ts", "ManageRedirects")
	]) ?>
}
@Body{
	<backend-service-container>
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="card rounded shadow mb-4">
						<div class="card-header">
							<div class="d-flex justify-content-between align-items-center">
								<h2 class="h6 mb-0">
									System Redirects
								</h2>
								<button type="button" class="btn btn-success" id="new-redirect-modal-trigger-button">
									<i class="bi bi-plus-circle-fill"></i>
									<span>Add a Redirect</span>
								</button>
							</div>
						</div>
						<div class="card-body">
							<p>
								Redirecting the backend pages is not possible. If a redirect would possibly redirect, for example, the backend page editor then that redirect is never processed. RegEx redirections should only be performed by an experienced user. Use a regular expression testing software or platform before implementing a RegEx redirect.
							</p>
							<div class="d-flex mb-3">
								<form id="redirect-search-form" class="me-auto">
									<div class="input-group">
										<span class="input-group-text">
											<i class="bi bi-search"></i>
										</span>
										<input type="text" id="redirect-search" name="query" class="form-control" placeholder="Search redirects">
									</div>
								</form>
                                <div class="ms-auto">
								    <?php include __DIR__ . "/../_partials/pagination.html" ?>
                                </div>
							</div>
							<div id="redirects-rows-headers" class="redirect-columns">
								<div class="regex">
									<strong>RegEx</strong>
								</div>
								<div class="from">
									<strong>From</strong>
								</div>
								<div class="to">
									<strong>To</strong>
								</div>
								<div class="status">
									<strong>HTTP Status</strong>
								</div>
								<div class="preserve-query-string">
									<strong>PQS</strong>
								</div>
								<div class="timestamp">
									<strong>Date Added</strong>
								</div>
								<div class="management-buttons"></div>
							</div>
							<div id="redirects-loader" class="text-center">
								<div style="width:5rem; height:5rem;" class="spinner-border" role="status">
									<span class="visually-hidden">Loading...</span>
								</div>
							</div>
							<div id="no-redirects-message-container" class="my-5 text-center" style="display:none;">
								<em>There are no redirects.</em>
							</div>
							<div id="redirects-rows-container"></div>
							<hr>
							<div class="d-flex justify-content-end">
								<?php include __DIR__ . "/../_partials/pagination.html" ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</backend-service-container>

	<?php include __DIR__ . "/modals/new-redirect-modal.html" ?>
	<?php include __DIR__ . "/modals/edit-redirect-modal.html" ?>
}
