@Layout = "backend-basic.php"
@Head{
	<title>System Review Manager</title>
	<?= \Uplift\Vite\ViteStaticService::Use([
		new \App\Vite\ViteResource("/uplift-core/resources/static/ts/ManageReviews/ManageReviews.ts", "ManageReviews")
	]) ?>

}
@Body{
	<backend-service-container>
		<div id="manage-reviews-page">
			<div class="card rounded shadow mb-4">
				<div class="card-header">
					<div class="d-flex justify-content-between align-items-center">
						<h2 class="h4 mb-0">
							First Party Reviews
						</h2>
					</div>
				</div>
				<div class="card-body">
					<div class="statistics-container">
						<div class="statistic-data">
							<div class="statistics-content">
								<div class="statistics-header overview-loaded-container">
									<h6>Average Rating</h6>
									<p>Recorded since <span id="reviews-overview-earliest-year"></span><p>
								</div>
								<div class="rating-stars overview-loaded-container" style="display: none;">
									<h3 id="reviews-overview-average-rating">4.7</h3>
									<div class="stars" id="reviews-overview-average-rating-stars-container"></div>
								</div>
								<div class="overview-loader">
									<div class="spinner-border text-primary"></div>
								</div>
							</div>	
						</div>
						<div class="statistic-data">
							<div class="statistics-content">
								<div class="statistics-header">
									<h6>Total Reviews</h6>
									<p>All time<p>
								</div>
								<div class="rating-stars overview-loaded-container" style="display: none;">
									<h3 id="reviews-overview-total-reviews"></h3>
								</div>
								<div class="overview-loader">
									<div class="spinner-border text-primary"></div>
								</div>
							</div>	
						</div>
						<div class="statistic-data">
							<div class="statistics-content">
								<div class="statistics-header">
									<h6>New Reviews</h6>
									<p>Since <span id="reviews-overview-30-days-ago"></span><p>
								</div>
								<div class="rating-stars overview-loaded-container" style="display: none;">
									<h3 id="reviews-overview-reviews-in-30-days">8</h3>
								</div>
								<div class="overview-loader">
									<div class="spinner-border text-primary"></div>
								</div>
							</div>	
						</div>
					</div>
						<div class="search-add-button d-flex justify-content-end">
								<form id="review-search-form" autocomplete="off" onsubmit="return false;">
									<div class="input-group">
										<span class="input-group-text border-end-0">
											<i class="bi bi-search"></i>
										</span>
										<input type="text" id="review-search" name="query" class="form-control border-start-0" placeholder="Search reviews">
									</div>
								</form>
								<button type="button" class="btn btn-success" id="new-review-modal-trigger-button">
									<span>Add a Review</span>
									<i class="bi bi-plus-circle"></i>
								</button>
						</div>
						<div id="reviews-table">
							<div id="reviews-rows-headers" class="review-columns">
								<div class="review-date">
									<h6>Date</h6>
								</div>
								<div class="location-name">
									<h6>Location</h6>
								</div>
								<div class="rating-row">
									<h6>Rating</h6>
								</div>
								<div class="review-author-name">
									<h6>Name</h6>
								</div>
								<div class="review-body">
									<h6>Testimonial</h6>
								</div>
								<div class="management-buttons">
									<h6>Actions</h6>
								</div>
							</div>
							<div>
								<div class="review-info-rows"></div>
								<div id="reviews-loader">
									<div class="d-flex justify-content-center">
										<div class="spinner-border" role="status">
											<span class="visually-hidden">Loading...</span>
										</div>
									</div>
								</div>
								<div id="no-reviews-message-container" style="display: none;" class="text-center py-3">
									<em>No reviews</em>
								</div>
							</div>
						</div>
						<hr>
						<div class="paginator justify-content-end">
							<?php include __DIR__ . "/../_partials/pagination.html" ?>
						</div>
				</div>
			</div>
		</div>
	</backend-service-container>
	
	<?php include __DIR__ . "/modals/read-full-testimonial-modal.html" ?>
}
