@Layout = "backend-basic.php"
@Head{
	<title>Manage Roles</title>
	<script defer src="/uplift-assets/js/_external/popper.js"></script>

	<?= \Uplift\Vite\ViteStaticService::Use([
    	new \App\Vite\ViteResource("/uplift-core/resources/static/ts/ManageRoles/List/Roles.ts", "Roles")
	]) ?>
}
@Body{
	<backend-service-container>
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="card rounded shadow mb-4">
						<div class="card-header">
							<div class="d-flex justify-content-between align-items-center">
								<h2 class="h6 mb-0">
									Role Manager
								</h2>
								<button class="btn btn-success" id="new-role-modal-button">
									<i class="bi bi-plus-circle"></i>
									<span>Add New Role</span>
								</button>
							</div>
						</div>
						<div class="card-body">
							<div id="roles-rows-headers" class="roles-columns">
								<div class="name">
									<strong>Name</strong>
								</div>
								<div class="date-created">
									<strong>Date Created</strong>
								</div>
								<div class="management-button"></div>
							</div>
							<div id="roles-loader" class="text-center">
								<div style="width:5rem; height:5rem;" class="spinner-border" role="status">
									<span class="visually-hidden">Loading...</span>
								</div>
							</div>
							<div id="roles-rows-container"></div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</backend-service-container>

	<?php include_once __DIR__ . "/modals/new-role-modal.php" ?>
}
