<?php
	/** @var array $viewScope */

	/** @var FSFile[] $systemLayouts */

	use FileSystemUtilities\FSFile;
	use Page\PublicationStatus;
	use System\Layouts;

	$systemLayouts = Layouts::getAvailableLayouts();
?>
<section>
	<div>
		<div class="bg-primary p-2">
			<h4 class="m-0 text-primary-contrast">Page Settings</h4>
		</div>
		<div class="container-fluid p-0">
			<div class="row g-0">
				<div class="col-xl-6">
					<h5 class="p-2 bg-secondary text-secondary-contrast">Identifying Data</h5>
					<div class="px-4 py-2">
						<div class="row mb-2">
							<div class="col-xl-6">
								<label for="page-name">Page name</label>
								<div class="input-group">
									<span class="input-group-text" id="page-name-addon"><i class="bi bi-input-cursor-text"></i></span>
									<input type="text" class="form-control" placeholder="Page name" id="page-name" name="page-name" autocomplete="off" aria-label="Page name" aria-describedby="page-name-addon" value="">
								</div>
							</div>
							<div class="col-xl-6">
								<label for="page-layout">Page layout</label>
								<div class="input-group">
									<span class="input-group-text" id="page-layout-addon"><i class="bi bi-grid-1x2-fill"></i></span>
									<select autocomplete="off" id="page-layout" aria-label="Page layout" aria-describedby="page-layout-addon" name="page-layout" class="form-control">
										<option value="">- Select a layout -</option>
										<?php
											foreach($systemLayouts as $fsFile){
												$layoutName = $fsFile->fileNameWithoutExtension;
												?>
													<option value="<?= $layoutName; ?>"><?= $layoutName; ?></option>
												<?php
											}
										?>
									</select>
								</div>
							</div>
						</div>
						<div class="mb-2">
							<label>Page route</label>
							<div class="input-group">
								<span class="input-group-text"><i class="bi bi-signpost-fill"></i></span>
								<input type="text" id="page-url" name="page-url" class="form-control" value="">
							</div>
						</div>
						<div class="mb-2">
							<label for="page-publication">Page publication <span class="tooltip-question-mark" title="Draft pages are not viewable on the front-end to users who are not logged in. Published pages are available to everyone."><i class="bi bi-question-circle"></i></span></label>
							<div class="input-group">
								<span class="input-group-text"><i class="bi bi-book-fill"></i></span>
								<select class="form-control" id="page-publication" name="page-publication-status">
									<?php
										foreach(PublicationStatus::cases() as $publicationStatus){
											?>
											<option value="<?= $publicationStatus->value ?>"><?= $publicationStatus->name ?></option>
											<?php
										}
									?>
								</select>
							</div>
						</div>
						<div id="page-publication-datetime-container" class="mb-3" style="display:none;">
							<label for="page-publication-timestamp">Publish date time <span class="tooltip-question-mark" title="The date and time this page should be able to be live. This only works if the Page Publication is set to Published and not Draft. Time is local to your current timezone."><i class="bi bi-question-circle"></i></span></label>
							<div class="input-group">
								<span class="input-group-text"><i class="bi bi-calendar-week-fill"></i></span>
								<input type="datetime-local" name="page-publication-timestamp" id="page-publication-timestamp" class="form-control">
							</div>
						</div>
                        <div class="mb-2">
                            <p>
                                Page Id: <span id="page-id"></span>
                            </p>
                        </div>
						<div>
							<div class="form-check mb-3">
								<input type="checkbox" class="form-check-input" id="exclude-from-sitemap" name="exclude-from-sitemap">
								<label class="form-check-label" for="exclude-from-sitemap">Exclude this page from sitemap</label>
							</div>
							<div class="form-check">
								<input type="checkbox" class="form-check-input" id="exclude-json-schema" name="exclude-json-schema">
								<label class="form-check-label" for="exclude-json-schema">Exclude this page from schema injection</label>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xl-6">
					<?php include __DIR__ . "/_breadcrumbs.php"; ?>
				</div>
			</div>
		</div>

		<?php include __DIR__ . "/_data-blog.php"; ?>
		<?php include __DIR__ . "/_data-city.php"; ?>
		<?php include __DIR__ . "/_data-project.php"; ?>
		<?php include __DIR__ . "/_data-service.php"; ?>
		<?php include __DIR__ . "/_featured-image.php" ?>
		<?php include __DIR__ . "/_data-attributes.php" ?>
	</div>
</section>
