<?php
	/** @var Page $page */
	/** @var ArticleCategory[] $articleCategories */

	use Nox\ORM\ColumnQuery;
	use Page\ArticleCategory;
	use Page\Page;
	use Page\PageArticleCategory;

	$existingPageArticleCategories = PageArticleCategory::query(
		columnQuery: (new ColumnQuery())
			->where("page_id","=",$page->id)
	);
?>
<textarea style="display:none;" id="init-all-system-article-categories"><?= json_encode($articleCategories); ?></textarea>
<textarea style="display:none;" id="init-page-linked-article-categories"><?= json_encode($existingPageArticleCategories); ?></textarea>
<div id="manage-blog-categories" class="modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">Manage Article Categories</h4>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<p>
					Highlighted rows represent blog categories that are selected for this blog post. Click a row to toggle a category for this blog post.
				</p>
				<form style="display:none;" id="new-article-category-form" class="mb-3">
					<label for="new-article-category-name" class="fs-6">Category name</label>
					<div class="input-group mb-2">
						<span class="input-group-text"><i class="bi bi-input-cursor-text"></i></span>
						<input placeholder="Name of the new category" class="form-control" type="text" name="new-article-category-name" id="new-article-category-name">
					</div>
					<div class="text-end">
						<button type="submit" class="btn btn-success btn-sm me-2">
							<i class="bi bi-plus-circle-fill"></i>
							<span>Create</span>
						</button>
						<button type="button" id="cancel-new-article-category-button" class="btn btn-gray btn-sm">
							<span>Cancel</span>
						</button>
					</div>
					<div class="p-2 bg-danger text-danger-contrast mt-2 submit-error" style="display:none;"></div>
				</form>
				<p id="enable-new-article-category-button-container">
					<button type="button" id="enable-new-article-category-form" class="btn btn-success btn-sm">
						<i class="bi bi-node-plus-fill"></i>
						<span>New Category</span>
					</button>
				</p>
				<hr>
				<div id="manage-article-category-rows"></div>
			</div>
		</div>
	</div>
</div>
