<?php
	/** @var array $articleCategories */

	use Page\ArticleCategory;

?>
<div id="blog-reel-modal" class="modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<form id="blog-reel-form" class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Add a Blog Reel</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="mb-3">
					<label for="articles-reel-num-articles-per-page">Articles per page</label>
					<div class="input-group">
						<div class="input-group-text">
							<i class="bi bi-123"></i>
						</div>
						<input id="articles-reel-num-articles-per-page" value="10" type="text" class="form-control" name="articles-reel-num-articles-per-page" placeholder="How many articles to show per page">
					</div>
				</div>
				<div class="mb-3">
					<label for="articles-reel-num-columns">Number of columns</label>
					<div class="input-group">
						<div class="input-group-text">
							<i class="bi bi-123"></i>
						</div>
						<input id="articles-reel-num-columns" value="1" type="text" class="form-control" name="articles-reel-num-columns" placeholder="How many columns to put the articles in">
					</div>
				</div>
				<?php
					if (!empty($articleCategories)){
						?>
						<div class="mb-3">
							<label>Which blog categories to include? Leave blank to include all.</label>
							<div>
								<?php
									/** @var ArticleCategory $articleCategory */
									foreach($articleCategories as $articleCategory){
										$categoryID = (int) $articleCategory->id;
										$categoryName = $articleCategory->name;
										?>
										<button type="button" data-category-id="<?= $categoryID ?>" class="blog-reel-category-include-button btn-sm btn btn-outline-primary">
											<i class="bi bi-tag-fill"></i>
											<span><?= $categoryName ?></span>
										</button>
										<?php
									}
								?>
							</div>
						</div>
						<?php
					}
				?>
				<?php
					if (!empty($articleCategories)){
						?>
						<div class="mb-3">
							<label>Exclude any categories from the blog reel?</label>
							<div>
								<?php
									/** @var ArticleCategory $articleCategory */
									foreach($articleCategories as $articleCategory){
										$categoryID = (int) $articleCategory->id;
										$categoryName = $articleCategory->name;
										?>
										<button type="button" data-category-id="<?= $categoryID ?>" class="blog-reel-category-exclude-button btn btn-sm btn-outline-danger">
											<i class="bi bi-tag-fill"></i>
											<span><?= $categoryName ?></span>
										</button>
										<?php
									}
								?>
							</div>
						</div>
						<?php
					}
				?>
				<div style="display:none;" class="submit-error bg-danger text-danger-contrast p-2 my-2"></div>
			</div>
			<div class="modal-footer">
				<button type="submit" class="btn btn-success">
					<i class="bi bi-file-arrow-up-fill"></i>
					<span>Insert</span>
				</button>
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
					<i class="bi bi-x-circle-fill"></i>
					<span>Cancel</span>
				</button>
			</div>
		</form>
	</div>
</div>
