<?php
	/** @var Page $page */

	use Page\Page;
	use Page\PageType;
?>
<div id="convert-page-type-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="convert-page-type-form">
				<div class="modal-header bg-primary text-primary-contrast">
					<h4 class="modal-title">Convert this page's type</h4>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
					<p>
						Converting allows you to change the type of page that is currently being used. For example, you can convert a general page to a blog post.
					</p>
					<div class="form-group">
						<div class="material-select-menu">
							<label>New page type</label>
							<select id="convert-page-new-page-type" name="new-page-type" class="form-control">
								<option value="0">- Select Page Type -</option>
								<?php
									foreach(PageType::cases() as $pageType){
										?>
										<option value="<?= $pageType->name; ?>"><?= $pageType->name; ?></option>
										<?php
									}
								?>
							</select>
						</div>
					</div>
					<div class="submit-error my-2 p-2 bg-danger text-danger-contrast" style="display:none;"></div>
				</div>
				<div class="modal-footer">
					<button type="submit" class="btn btn-success">
						<span>Convert Page</span>
					</button>
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
						<span>Cancel</span>
					</button>
				</div>
			</div>
		</form>
	</div>
</div>
