<?php
	/** @var ProjectPostTag[] $allProjectTags These are the system tags and not just the ones assigned to this page */

	use ProjectPostTag\ProjectPostTag;
?>
<textarea style="display:none;" id="init-all-system-project-tags"><?= json_encode($allProjectTags) ?></textarea>
<div id="manage-project-tags-modal" class="modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">Manage Project Tags</h4>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<p>
					Highlighted rows represent project tags that are selected for this IPP. Click a row to toggle a tag to be selected.
				</p>
				<form style="display:none;" id="new-project-tag-form" class="mb-3">
					<label for="new-project-tag-label" class="fs-6">Project tag name</label>
					<div class="input-group mb-2">
						<span class="input-group-text"><i class="bi bi-input-cursor-text"></i></span>
						<input placeholder="Name of the new project tag" class="form-control" type="text" name="new-project-tag-label" id="new-project-tag-label">
					</div>
					<div class="text-end">
						<button type="submit" class="btn btn-success btn-sm me-2">
							<i class="bi bi-plus-circle-fill"></i>
							<span>Create</span>
						</button>
						<button type="button" id="cancel-new-project-tag-button" class="btn btn-gray btn-sm">
							<span>Cancel</span>
						</button>
					</div>
					<div class="p-2 bg-danger text-danger-contrast mt-2 submit-error" style="display:none;"></div>
				</form>
				<p id="enable-new-project-tag-button-container">
					<button type="button" id="enable-new-project-tag-form" class="btn btn-success btn-sm">
						<i class="bi bi-node-plus-fill"></i>
						<span>New Project Tag</span>
					</button>
				</p>
				<hr>
				<div id="manage-project-tag-rows"></div>
			</div>
		</div>
	</div>
</div>
