<?php
	/** @var array $articleCategories */

	use Page\ArticleCategory;

?>
<div id="recent-articles-modal" class="modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<form id="recent-articles-form" class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Add recent articles</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="mb-3">
					<label for="recent-articles-num-articles-input">Number of articles</label>
					<div class="input-group">
						<div class="input-group-text">
							<i class="bi bi-123"></i>
						</div>
						<input id="recent-articles-num-articles-input" value="2" type="text" class="form-control" name="num-recent-articles">
					</div>
				</div>
				<div class="mb-3">
					<label for="recent-articles-num-columns-input">Number of columns</label>
					<div class="input-group">
						<div class="input-group-text">
							<i class="bi bi-123"></i>
						</div>
						<input id="recent-articles-num-columns-input" value="1" type="text" class="form-control" name="recent-articles-num-columns">
					</div>
				</div>
				<div class="mb-3">
					<div class="mb-2">
						<span>Optionally, you can include only articles in specific categories. Selecting none will include all article categories.</span>
					</div>
					<div id="recent-articles-categories-loader">
						<div class="spinner-border text-primary"></div>
					</div>
					<div id="recent-articles-no-article-categories" style="display:none;">
						<span><em>The system has no article categories - you cannot narrow down to selected categories right now.</em></span>
					</div>
					<div id="recent-articles-buttons-container">

					</div>
				</div>
				<div class="mb-3">
					<div class="mb-2">Autofill articles if the selected article categories don't have enough articles to satisfy <em>Number of articles</em>?</div>
					<div class="form-check">
						<input class="form-check-input" type="checkbox" value="" id="recent-articles-autofill">
						<label class="form-check-label" for="recent-articles-autofill">
							Autofill
						</label>
					</div>
				</div>
				<div class="submit-error bg-danger text-danger-contrast p-2 my-2" style="display:none;"></div>
			</div>
			<div class="modal-footer">
				<button type="submit" class="btn btn-success">
					<i class="bi bi-file-arrow-up-fill"></i>
					<span>Insert</span>
				</button>
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
					<i class="bi bi-x-circle-fill"></i>
					<span>Cancel</span>
				</button>
			</div>
		</form>
	</div>
</div>
