<?php

?>
@Layout = "backend-basic.php"
@Head{
	<title>Deleted Page Restoration</title>
	<script type="module" src="/uplift-assets/js/page-restoration/PageRestoration.js"></script>
}
@Body{
	<backend-service-container>
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="card">
						<div class="card-header">
							<h2 class="mb-0">Deleted Page Restoration</h2>
						</div>
						<div class="card-body">
							<div>
								<p>
									Below is a list of pages that no longer exist in this system, but there are edit archives for them. You can use this interface to restore a deleted page to the last saved edit archive. This includes its breadcrumbs and page data.
								</p>
							</div>
							<form id="page-restoration-query-form">
								<div class="input-group">
									<label class="input-group-text" for="page-query-input">
										<i class="me-1 bi bi-search"></i>
										<span>Search</span>
									</label>
									<input id="page-query-input" type="text" class="form-control" name="query">
								</div>
							</form>
							<hr>
							<div class="text-end">
								<div class="paginator-container"></div>
							</div>
							<div id="no-results" style="display:none;">
								<div class="text-center">
									<em>No results</em>
								</div>
							</div>
							<div id="loader">
								<div class="text-center">
									<div class="spinner-border text-primary" style="width:5rem; height:5rem;"></div>
								</div>
							</div>
							<table id="page-restoration-table" class="table">
								<thead>
									<tr class="page-restoration-table-columns">
										<th>
											Row ID
										</th>
										<th>
											Page ID
										</th>
										<th>
											Page Name
										</th>
										<th>
											Page Creation Time
										</th>
										<th></th>
									</tr>
								</thead>
								<tbody id="results-container"></tbody>
							</table>
							<div class="text-end">
								<div class="paginator-container"></div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</backend-service-container>
}