<?php
	use Page\Page;
	use PageEditor\PageEditorService;

	/** @var array{revisions: stdClass[], page: Page} $viewScope */
	$revisions = $viewScope['revisions'];
	$page = $viewScope['page'];
?>
@Layout = "backend-basic.php"
@Head{
	<title>View Revisions for Page</title>
}
@Body{
	<backend-service-container>
		<div class="container">
			<div class="col-12">
				<div class="card">
					<div class="card-header">
						<h2>Latest <?= PageEditorService::PAGE_HISTORY_VIEW_LIMIT ?> Revision History Entries for <em><?= htmlspecialchars($page->pageName) ?></em></h2>
					</div>
					<div class="card-body">
						<div id="revision-rows-header">
							<div class="revision-row-column-sizes">
								<div class="id">
									ID
								</div>
								<div class="timestamp">
									Revision Date
								</div>
								<div class="head-size">
									Head Size
								</div>
								<div class="body-size">
									Body Size
								</div>
								<div class="buttons"></div>
							</div>
						</div>
						<div id="revision-rows">
							<?php
								foreach($revisions as $revision){
									?>
									<div class="revision-row revision-row-column-sizes">
										<div class="id">
											<?= $revision->id ?>
										</div>
										<div class="timestamp">
											<?= date("M d, Y H:i", $revision->archivedTimestamp) ?>
										</div>
										<div class="head-size">
											<?= number_format($revision->pageHeadLength) ?>
										</div>
										<div class="body-size">
											<?= number_format($revision->pageBodyLength) ?>
										</div>
										<div class="buttons">
											<a class="btn btn-primary btn-sm" href="/uplift/page-editor/revisions/<?= $page->id ?>/<?= $revision->id ?>">
												<i class="bi bi-bezier2"></i>
												<span>View Revision</span>
											</a>
										</div>
									</div>
									<?php
								}
							?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</backend-service-container>
}
