@Layout = "backend-basic.php"
@Head{
<title>Senzu Importer</title>
<script type="module" src="/uplift-assets/js/senzu-importer/SenzuImporter.js"></script>
<script defer src="/uplift-assets/js/_external/popper.min.js"></script>
}
@Body{
<backend-service-container>
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="card rounded shadow mb-4">
					<div class="card-header">
						<div class="d-flex justify-content-between align-items-center">
							<h2 class="mb-0">
								Senzu Content Importer
							</h2>
						</div>
					</div>
					<div class="card-body">
						<form id="senzu-content-fetch-form">
							<p>
								First, enter the numerical ID of the Senzu site to fetch the written content for that site. Then, you'll be able to customize the data or add extra pages as necessary.
							</p>
							<div class="mb-3">
								<div class="input-group">
									<label for="site-id-input" class="input-group-text">
										<i class="me-2 bi bi-cloud-download-fill"></i>
										<span>Site ID</span>
									</label>
									<input id="site-id-input" placeholder="E.g. 301" type="number" class="form-control" name="site-id">
									<button id="site-fetch-button" type="submit" class="btn btn-success">
										<i id="site-fetch-button-icons" class="bi bi-cloud-download-fill"></i>
										<span id="site-fetch-button-spinner" style="display:none;width:1rem;height:1rem;" class="spinner-border text-white"></span>
										<span>Fetch Content</span>
									</button>
								</div>
							</div>
						</form>
						<form id="content-build-form" style="display:none;">

							<section class="page-type-section">
								<div class="d-flex align-items-center my-3">
									<hr style="width:50px;">
									<h2 class="text-nowrap mx-3">General Pages</h2>
									<hr class="w-100">
									<button style="display:none;" type="button" id="new-general-page-button" class="ms-3 btn btn-sm btn-primary text-nowrap">
										<i class="bi bi-file-plus-fill"></i>
										<span>New Page</span>
									</button>
								</div>
								<div id="no-general-pages-message" class="no-pages-message" style="display:none;">
									<em>No pages in this category.</em>
								</div>
								<div id="general-pages-container" class="page-type-container"></div>
							</section>

							<section class="page-type-section">
								<div class="d-flex align-items-center my-3">
									<hr style="width:50px;">
									<h2 class="text-nowrap mx-3">Service Pages</h2>
									<hr class="w-100">
									<button style="display:none;" type="button" id="new-service-page-button" class="ms-3 btn btn-sm btn-primary text-nowrap">
										<i class="bi bi-file-plus-fill"></i>
										<span>New Page</span>
									</button>
								</div>
								<div id="no-service-pages-message" class="no-pages-message" style="display:none;">
									<em>No pages in this category.</em>
								</div>
								<div id="service-pages-container" class="page-type-container"></div>
							</section>

							<section class="page-type-section">
								<div class="d-flex align-items-center my-3">
									<hr style="width:50px;">
									<h2 class="text-nowrap mx-3">City Pages</h2>
									<hr class="w-100">
									<button style="display:none;" type="button" id="new-city-page-button" class="ms-3 btn btn-sm btn-primary text-nowrap">
										<i class="bi bi-file-plus-fill"></i>
										<span>New Page</span>
									</button>
								</div>
								<div id="no-city-pages-message" class="no-pages-message" style="display:none;">
									<em>No pages in this category.</em>
								</div>
								<div id="city-pages-container" class="page-type-container"></div>
							</section>

							<section class="page-type-section">
								<div class="d-flex align-items-center my-3">
									<hr style="width:50px;">
									<h2 class="text-nowrap mx-3">Blog Pages</h2>
									<hr class="w-100">
									<button style="display:none;" type="button" id="new-blog-page-button" class="ms-3 btn btn-sm btn-primary text-nowrap">
										<i class="bi bi-file-plus-fill"></i>
										<span>New Page</span>
									</button>
								</div>
								<div id="no-blog-pages-message" class="no-pages-message" style="display:none;">
									<em>No pages in this category.</em>
								</div>
								<div id="blog-pages-container" class="page-type-container"></div>
							</section>

							<section class="page-type-section">
								<div class="d-flex align-items-center my-3">
									<hr style="width:50px;">
									<h2 class="text-nowrap mx-3">Project Pages</h2>
									<hr class="w-100">
									<button style="display:none;" type="button" id="new-project-page-button" class="ms-3 btn btn-sm btn-primary text-nowrap">
										<i class="bi bi-file-plus-fill"></i>
										<span>New Page</span>
									</button>
								</div>
								<div id="no-project-pages-message" class="no-pages-message" style="display:none;">
									<em>No pages in this category.</em>
								</div>
								<div id="project-pages-container" class="page-type-container"></div>
							</section>

							<div class="fixed-footer-button d-flex flex-column">
								<button type="submit" class="btn btn-success mb-3">
									<i class="bi bi-file-earmark-arrow-down-fill"></i>
									<span>Build Pages from Content</span>
								</button>
								<button data-bs-toggle="modal" data-bs-target="#manage-parents-modal" type="button" class="btn btn-info">
									<i class="bi bi-file-earmark-arrow-down-fill"></i>
									<span>Define Virtual Parents</span>
								</button>
							</div>

						</form>
						<div id="content-build-loader" class="text-center" style="display:none;">
							<div class="spinner-border text-primary" style="width:8rem; height:8rem;"></div>
						</div>
						<div id="content-build-success" class="text-center" style="display:none;">
							<div class="alert alert-success">
								<h4>Import Successful</h4>
								<p>
									The pages have been imported and constructed. Any pages with the same name have been overwritten.
								</p>
								<a href="/uplift/page-editor" class="btn btn-success">
									<i class="bi bi-pen-fill"></i>
									<span>Go to Page Editor</span>
								</a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</backend-service-container>

<?php include __DIR__ . "/modals/manage-parents.html" ?>
<?php include __DIR__ . "/modals/manage-page-data.php" ?>
<?php include __DIR__ . "/../_partials/image-manager/_main.php" ?>

}
