<?php
	use Page\PageDatas;
?>
<div id="manage-page-data-modal" class="modal" tabindex="-1">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Manage Page Data</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<form id="new-page-data-form">
					<div class="input-group">
						<label for="page-data-type-input" class="input-group-text">Data Type</label>
						<select name="page-data-type" id="page-data-type-input" class="form-control">
							<option value="-1">- Select Data Type</option>
							<?php
								foreach(PageDatas::cases() as $pageData){
									?>
									<option value="<?= $pageData->name ?>"><?= $pageData->name ?></option>
									<?php
								}
							?>
						</select>
						<button type="submit" class="btn btn-primary btn-sm">
							<i class="bi bi-clipboard2-data-fill"></i>
							<span>Add Page Data</span>
						</button>
					</div>
				</form>
				<div id="page-data-container">

				</div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
					<i class="bi bi-x-square-fill"></i>
					<span>Close</span>
				</button>
			</div>
		</div>
	</div>
</div>