<?php
	/** @var array $viewScope */

	use Settings\Settings;
?>
<form id="robot-settings-form" class="card rounded shadow mb-4">
	<div class="card-header">
		<h4 class="mb-0">
			Robot Settings
		</h4>
	</div>
	<div class="card-body">
		<div>
			<p>
				Use this to edit the robots.txt file that is found at the route <strong>/robots.txt</strong>
			</p>
		</div>
		<div>
			<label for="robots" class="form-label">File content</label>
			<textarea
				id="robots"
				autocomplete="off"
				name="robots"
				class="form-control"
				rows="5"
			><?= htmlspecialchars((string) $viewScope[Settings::ROBOTS_FILE_CONTENT->name]) ?></textarea>
		</div>
	</div>
	<div class="card-footer">
		<div class="text-end">
			<button type="submit" class="btn btn-success">
				<i class="bi bi-check-circle-fill"></i>
				<span>Save Robots</span>
			</button>
		</div>
	</div>
</form>