<?php
	/** @var array $viewScope */

	use Settings\Settings;

?>
<form id="uplift-settings-form" class="card rounded shadow mb-4">
	<div class="card-header">
		<h4 class="mb-0">
			Uplift System Settings
		</h4>
	</div>
	<div class="card-body">
		<div class="form-check mb-3">
			<input class="form-check-input" type="checkbox" id="force-https-protocol" name="forceHTTPs" <?= $viewScope[Settings::FORCE_HTTPS->name] === "1" ? "checked" : "" ?> >
			<label class="form-check-label" for="force-https-protocol">
				Force HTTPS Protocol
			</label>
		</div>
		<div class="form-check mb-3">
			<input class="form-check-input" type="checkbox" id="enable-noindex" name="noindex" <?= $viewScope[Settings::ENTIRE_SITE_NO_INDEX->name] === "1" ? "checked" : "" ?> >
			<label class="form-check-label" for="enable-noindex">
				Disallow search engines to index site (Enables noindex)
			</label>
		</div>
		<div class="form-check mb-3">
			<input class="form-check-input" type="checkbox" id="site-suspended" name="siteSuspended" <?= $viewScope[Settings::SITE_SUSPENDED->name] === "1" ? "checked" : "" ?> >
			<label class="form-check-label" for="site-suspended">
				Suspend Site (Disables the site front-end)
			</label>
		</div>
		<div class="form-check mb-3">
			<input class="form-check-input" type="checkbox" id="disable-ipp-form" name="ippFormDisabled" <?= $viewScope[Settings::IPP_FORM_DISABLED->name] === "1" ? "checked" : "" ?> >
			<label class="form-check-label" for="disable-ipp-form">
				Disable IPP Form
			</label>
		</div>
		<div>
			<p>
				Updating the thumbnail size settings below does not retroactively affect existing thumbnails. You can use the image manager window to regenerate existing thumbnails for images manually. It is recommended that you use square dimensions for thumbnail sizes.
			</p>
		</div>
		<div class="container-fluid px-0">
			<div class="row">
				<div class="col-6">
					<label for="thumbnail-x">Thumbnail Width</label>
					<div class="input-group">
						<div class="input-group-text"><i class="bi bi-aspect-ratio-fill"></i></div>
						<input id="thumbnail-x" autocomplete="off" type="text" name="thumbnailUploadSizeX" class="form-control" value="<?= $viewScope[Settings::THUMBNAIL_UPLOAD_SIZE_X->name] ?>">
						<div class="input-group-text">px</div>
					</div>
					<small>The X axis. In pixels.</small>
				</div>
				<div class="col-6">
					<label for="thumbnail-y">Thumbnail Height</label>
					<div class="input-group">
						<div class="input-group-text"><i class="bi bi-aspect-ratio-fill"></i></div>
						<input id="thumbnail-y" autocomplete="off" type="text" name="thumbnailUploadSizeY" class="form-control" value="<?= $viewScope[Settings::THUMBNAIL_UPLOAD_SIZE_Y->name] ?>">
						<div class="input-group-text">px</div>
					</div>
					<small>The Y axis. In pixels.</small>
				</div>
			</div>
		</div>
	</div>
	<div class="card-footer">
		<div class="text-end">
			<button type="submit" class="btn btn-success">
				<i class="bi bi-check-circle-fill"></i>
				<span>Save Uplift Settings</span>
			</button>
		</div>
	</div>
</form>