<?php

	/** @var array $viewScope */

	use Settings\Setting;
	use Settings\Settings;

	$settings = $viewScope['settings'];

?>
@Layout = "backend-basic.php"
@Head{
	<title>Internal Settings</title>
	<script type="module" src="/uplift-assets/js/settings/Settings.js"></script>
}
@Body{
	<backend-service-container>
		<div class="container">
			<?php
				if (Setting::getSettingValue(Settings::CORE_NEEDS_UPDATING->value) === "1"){
					include __DIR__ . "/_update-notification.php";
				}
			?>
			<div class="row mb-3">
				<div class="col-12">
					<div class="text-end">
						<em>Ctrl + s will save all settings on the page <i class="bi bi-question-circle-fill"></i></em>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-12">
					<?php include __DIR__ . "/_company-info.php" ?>
					<?php include __DIR__ . "/_system-settings.php" ?>
					<?php include __DIR__ . "/_content-settings.php" ?>
					<?php include __DIR__ . "/_robots-content.php" ?>
					<?php include __DIR__ . "/_injections.php" ?>
					<?php include __DIR__ . "/_build-registration.php" ?>
				</div>
			</div>
		</div>
	</backend-service-container>
}
