<?php
	/** @var array{firstName: string, lastName: string, upliftApiKey: string} $viewScope */
	$upliftApiKey = $viewScope['upliftApiKey'];
	$firstName = $viewScope['firstName'];
	$lastName = $viewScope['lastName'];
?>
@Layout = "backend-no-includes.php"
@Head{
	<title>Create a New Account</title>
	<script type="module" src="/uplift-assets/js-prod/UserAccounts/CreateGeneralAccountByAPI/CreateGeneralAccountByAPI.js"></script>
}
@Body{
	<backend-service-container>
		<div class="container">
			<div class="row">
				<div class="col-xxl-6 order-xxl-0 order-1">
					<div class="card">
						<div class="card-header bg-primary text-white">
							<h4 class="mb-0">Create a CMS Account</h4>
						</div>
						<div class="card-body">
							<form id="new-general-account-form">
								<input type="hidden" name="uplift-api-key" value="<?= $upliftApiKey ?>">
								<div class="container-fluid p-0">
									<div class="row mb-2">
										<div class="col-lg-6 mb-lg-0 mb-2">
											<label for="first-name-input">First Name</label>
											<div class="input-group">
												<input readonly id="first-name-input" type="text" class="form-control" name="first-name" value="<?= $firstName ?>" autocomplete="offf">
											</div>
										</div>
										<div class="col-lg-6">
											<label for="last-name-input">Last Name</label>
											<div class="input-group">
												<input readonly id="last-name-input" type="text" class="form-control" name="last-name" value="<?= $lastName ?>" autocomplete="offf">
											</div>
										</div>
									</div>
								</div>
								<div class="mb-2">
									<label for="username-input">Username</label>
									<div class="input-group">
										<input id="username-input" type="text" class="form-control" name="username" autocomplete="offf">
									</div>
								</div>
								<div class="mb-2">
									<label for="email-input">Email</label>
									<div class="input-group">
										<input id="email-input" type="email" class="form-control" name="email" autocomplete="offf">
									</div>
								</div>
								<div class="mb-2">
									<label for="password-input">Password</label>
									<div class="input-group">
										<input id="password-input" type="password" class="form-control" name="password" autocomplete="offf">
									</div>
								</div>
							</form>
							<hr>
							<div>
								<div id="form-error-container" style="display:none;">
									<div id="form-error" class="alert alert-danger"></div>
								</div>
								<div id="form-loader" style="display:none;">
									<div class="spinner-border"></div>
								</div>
								<div id="form-submit-buttons">
									<button type="submit" form="new-general-account-form" class="btn btn-primary">
										<i class="bi bi-person-circle"></i>
										<span>Create Account</span>
									</button>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xxl-6 order-xxl-1 order-0">
					<div id="new-general-account-info-container">
						<h2>New General Uplift Account</h2>
						<p>
							We don't have an account in the system with the name <?= $firstName ?> <?= $lastName ?>. <strong>Even if you have previously logged in with a client account</strong>, go ahead and create a new account under your name so all changes and access is specifically tailored to you instead of a generic account.
						</p>
						<p>
							After creating this account, your Client Dashboard will directly log you in from your Client Dashboard directly each time. After creation on this page, you will be redirected to your Uplift CMS dashboard with your new account.
						</p>
					</div>
				</div>
			</div>
		</div>
	</backend-service-container>
}
