<?php
	/** @var array $viewScope */
	/** @var Account $managedAccount */

	use Accounts\Account;
	use Roles\PermissionCategories;

	$currentAccount = Account::getCurrentUser();
	$managedAccount = $viewScope['managedAccount'];
	$roles = $viewScope['roles'];
	$activityLogCategories = $viewScope['activityLogCategories'];
?>
@Layout = "backend-basic.php"
@Head{
	<title>Managing <?= $managedAccount->getFullName() ?></title>
	<script defer src="/uplift-assets/js/_external/popper.js"></script>
	<script type="module" defer src="/uplift-assets/js/_external/bootstrap/collapse.js"></script>
	<script type="module" src="/uplift-assets/js/user-accounts/ManageUserAccount.js"></script>
	<script type="module" src="/uplift-assets/js/activity-logs/ActivityLogs.js"></script>
}
@Body{
	<backend-service-container>
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="card rounded shadow mb-4">
						<div class="card-header">
							<h2 class="h6 mb-0">
								Managing <?= $managedAccount->getFullName() ?>
							</h2>
						</div>
						<div class="card-body">
							<div class="container-fluid">
								<div class="row">
									<div id="user-management-data-column" class="col-xl-8">
										<form id="edit-user-form">
											<input type="hidden" id="account-id" value="<?= $managedAccount->id ?>">
											<div class="mb-3">
												<div class="row">
													<div class="col-xl">
														<label for="edit-user-username">Username</label>
														<input readonly type="text" class="form-control" id="edit-user-username" value="<?= htmlspecialchars($managedAccount->username) ?>">
														<small>This is not changeable</small>
													</div>
												</div>
											</div>
											<div class="mb-3">
												<div class="row">
													<div class="col-xl">
														<label for="edit-user-first-name">First name</label>
														<input type="text" class="form-control" name="first-name" id="edit-user-first-name" value="<?= htmlspecialchars($managedAccount->firstName) ?>">
													</div>
													<div class="col-xl">
														<label for="edit-user-last-name">Last name</label>
														<input type="text" class="form-control" name="last-name" id="edit-user-last-name" value="<?= htmlspecialchars($managedAccount->lastName) ?>">
													</div>
												</div>
											</div>
											<div class="mb-3">
												<div class="row">
													<div class="col-xl">
														<label for="edit-user-email">Email</label>
														<input type="email" name="email" class="form-control" id="edit-user-email" value="<?= htmlspecialchars($managedAccount->email) ?>">
													</div>
												</div>
											</div>
											<div class="mb-3">
												<div class="row">
													<div class="col-xl">
														<label for="edit-account-role">Permission role</label>
														<select class="form-control" name="role-id" id="edit-account-role">
															<?php
																foreach($roles as $role){
																	$selectedAttribute = $role->id === $managedAccount->roleID ? "selected" : "";
																	?>
																	<option <?= $selectedAttribute ?> value="<?= $role->id ?>"><?= $role->name ?></option>
																	<?php
																}
															?>
														</select>
													</div>
												</div>
											</div>
											<div>
												<div class="row">
													<div class="col-xl">
														<button type="submit" class="btn btn-success">
															<i class="bi bi-check-circle-fill"></i>
															<span>Save</span>
														</button>
													</div>
												</div>
											</div>
										</form>
									</div>
									<div class="col-xl">
										<div class="mb-2">
											<button id="change-password-button" type="button" class="btn btn-primary">
												<i class="bi bi-lock-fill"></i>
												<span>Change Password</span>
											</button>
										</div>
										<div class="mb-2">
											<?php
												if ($managedAccount->disabled === 1){
													?>
													<button id="enable-account-button" type="button" class="btn btn-success">
														<i class="bi bi-unlock-fill"></i>
														<span>Re-Enable Account</span>
													</button>
													<?php
												}else{
													?>
													<button id="disable-account-button" type="button" class="btn btn-danger">
														<i class="bi bi-dash-circle-fill"></i>
														<span>Disable Account</span>
													</button>
													<?php
												}
											?>

										</div>
									</div>
								</div>
								<?php
									if($currentAccount->hasPermission(PermissionCategories::VIEW_ACTIVITY_LOGS)) {
								?>
								<div class="row">
									<div class="col-xl">
										<hr>
										<div>
											<h4>Latest User Activity from Logs</h4>
											<div class="d-flex justify-content-end mb-3">
												<form>
													<select class="form-select" id="category-select">
														<option value="0" selected>All Logs</option>
														<?php
															$arrayColumn = array_column($activityLogCategories, "name");
															array_multisort($arrayColumn, $activityLogCategories);

															foreach($activityLogCategories as $category) {
																echo("<option value='$category->value'>" . $category->name. "</option>");
															}
														?>
													</select>
												</form>
											</div>
											<div id="activity-log-loader" class="text-center" style="display: none;">
												<div style="width:5rem; height:5rem;" class="spinner-border" role="status">
													<span class="visually-hidden">Loading...</span>
												</div>
											</div>
											<div id="activity-log-rows-container" data-user="<?= $managedAccount->id ?>"></div>
											<p id="no-logs-to-display-message" style="display: none;">
												There are no logs of this category type.
											</p>
											<div class="d-flex justify-content-end">
												<?php include __DIR__ . "/../_partials/pagination.html" ?>
											</div>
										</div>
									</div>
								</div>
								<?php
									}
								?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</backend-service-container>

	<?php include_once __DIR__ . "/modals/new-password-modal.php" ?>
}
