<?php
	/** @var array{roles: array} $viewScope */

	/** @var Role[] $roles */

	use Roles\Role;

	$roles = $viewScope['roles'];
?>
<div id="new-user-modal" class="modal" role="dialog">
	<div class="modal-dialog modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Add a User Account</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<form id="new-user-form" autocomplete="off">
					<p>
						<span class="text-danger">*</span> denotes a required field
					</p>
					<hr>
					<div class="mb-3">
						<label for="new-account-username">Username <span class="text-danger">*</span></label>
						<input autocomplete="off" type="text" class="form-control" name="username" id="new-account-username" placeholder="E.g, david_S1999">
						<small>Must be unique - two accounts can't share the same username</small>
					</div>
					<div class="mb-3">
						<div class="container-fluid p-0">
							<div class="row">
								<div class="col-xl-6">
									<label for="new-account-first-name">First name <span class="text-danger">*</span></label>
									<input type="text" class="form-control" name="first-name" id="new-account-first-name" placeholder="">
								</div>
								<div class="col-xl-6">
									<label for="new-account-last-name">Last name <span class="text-danger">*</span></label>
									<input type="text" class="form-control" name="last-name" id="new-account-last-name" placeholder="">
								</div>
							</div>
						</div>
					</div>
					<div class="mb-3">
						<label for="new-account-email">Email</label>
						<input type="email" class="form-control" name="email" id="new-account-email" placeholder="E.g, example@example.com">
						<small>For notifications and account recovery</small>
					</div>
					<div class="mb-3">
						<label for="new-account-password">Password <span class="text-danger">*</span></label>
						<div class="input-group">
							<input autocomplete="offf" type="password" class="form-control" name="password" id="new-account-password">
							<span title="Show password" class="input-group-text" id="new-account-password-viewer-icon">
								<i class="bi bi-eye-fill"></i>
							</span>
						</div>
					</div>
					<div class="mb-3">
						<label for="new-account-role">Permission role <span class="text-danger">*</span></label>
						<select class="form-control" name="role" id="new-account-role">
							<?php
								foreach($roles as $role){
									?>
									<option value="<?= $role->id ?>"><?= $role->name ?></option>
									<?php
								}
							?>
						</select>
					</div>
				</form>
			</div>
			<div class="modal-footer">
				<button form="new-user-form" type="submit" class="btn btn-primary">
					<i class="bi bi-person-video2"></i>
					<span>Create User</span>
				</button>
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
					<span>Cancel</span>
				</button>
			</div>
		</div>
	</div>
</div>