<?php

	namespace Accounts;

	use Nox\ORM\Attributes\Model;
	use Nox\ORM\ColumnDefinition;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\MySQLDataTypes\Integer;
	use Nox\ORM\MySQLDataTypes\TinyInteger;
	use Nox\ORM\MySQLDataTypes\VariableCharacter;
	use NoxEnv;

	#[Model]
	class AccountsModel implements MySQLModelInterface
	{

		/**
		 * The name of this Model in the MySQL database as a table
		 */
		private string $mysqlDatabaseName = NoxEnv::MYSQL_DB_NAME;

		/**
		 * The name of this Model in the MySQL database as a table
		 */
		private string $mysqlTableName = NoxEnv::MYSQL_TABLE_NAME_PREFIX . "accounts";

		/**
		 * The string name of the class this model represents and can instantiate
		 */
		private string $representingClassName = Account::class;

		public function getDatabaseName(): string
		{
			return $this->mysqlDatabaseName;
		}

		public function getName(): string
		{
			return $this->mysqlTableName;
		}

		public function getInstanceName(): string
		{
			return $this->representingClassName;
		}

		public function getColumns(): array
		{
			return [
				new ColumnDefinition(
					name: "id",
					classPropertyName: "id",
					dataType: new Integer(),
					defaultValue: 0,
					autoIncrement: true,
					isPrimary: true,
					isNull: false,
				),
				new ColumnDefinition(
					name: "username",
					classPropertyName: "username",
					dataType: new VariableCharacter(128),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "firstName",
					classPropertyName: "firstName",
					dataType: new VariableCharacter(128),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "lastName",
					classPropertyName: "lastName",
					dataType: new VariableCharacter(128),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "password",
					classPropertyName: "password",
					dataType: new VariableCharacter(255),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "email",
					classPropertyName: "email",
					dataType: new VariableCharacter(255),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "role",
					classPropertyName: "role",
					dataType: new VariableCharacter(255),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "role_id",
					classPropertyName: "roleID",
					dataType: new Integer(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "creationTime",
					classPropertyName: "creationTime",
					dataType: new Integer(),
					defaultValue: time(),
				),
				new ColumnDefinition(
					name: "canBeDeleted",
					classPropertyName: "canBeDeleted",
					dataType: new TinyInteger(1),
					defaultValue: 1,
				),
				new ColumnDefinition(
					name: "disabled",
					classPropertyName: "disabled",
					dataType: new TinyInteger(1),
					defaultValue: 0,
				),
			];
		}
	}
