<?php

	namespace Accounts\Attributes;

	use Accounts\Account;
	use Nox\Router\AttributeResponse;
	use Nox\Router\Interfaces\RouteAttribute;

	#[\Attribute(\Attribute::TARGET_METHOD)]
	class RequireLogin implements RouteAttribute{

		public function __construct(
			public bool $redirect = false,
			public ?string $redirectURI = null,
		){}

		public function getAttributeResponse(): AttributeResponse
		{
			/** @var Account | null $currentUser */
			$currentUser = Account::getCurrentUser();

			if ($currentUser === null) {
				if ($this->redirect){
					if ($this->redirectURI !== null){
						return new AttributeResponse(
							isRouteUsable: false,
							responseCode: 403,
							newRequestPath: "/admin-panel"
						);
					}
				}

				return new AttributeResponse(
					isRouteUsable: false,
					responseCode: 403,
				);
			}else{
				return new AttributeResponse(
					isRouteUsable: true,
				);
			}
		}
	}