<?php

	namespace Accounts\Attributes;

	use Accounts\Account;
	use Attribute;
	use Nox\ORM\ColumnQuery;
	use Nox\Router\AttributeResponse;
	use Nox\Router\Interfaces\RouteAttribute;
	use Roles\Permission;
	use Roles\PermissionCategories;

	#[Attribute(Attribute::TARGET_METHOD)]
	class RequirePermission implements RouteAttribute {
		public function __construct(
			public PermissionCategories $requiredPermission,
		){}

		public function getAttributeResponse(): AttributeResponse{
			/** @var Account | null $currentUser */
			$currentUser = Account::getCurrentUser();

			if ($currentUser->hasPermission($this->requiredPermission)) {
				return new AttributeResponse(
					isRouteUsable: true,
				);
			}else{
				return new AttributeResponse(
					isRouteUsable: false,
					responseCode: 403,
				);
			}
		}
	}