<?php

	namespace ActivityLogs;

	use Nox\ORM\Interfaces\ModelInstance;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\ModelClass;

	class ActivityLog extends ModelClass implements ModelInstance
	{

		public ?int $id = null;
		public int $categoryID;
		public int $userID;
		public string $ip;
		public int $timestamp;
		public string $jsonData;

		public static function getModel(): MySQLModelInterface
		{
			return new ActivityLogsModel();
		}

		public static function log(
			int    $categoryID,
			int    $accountID,
			string $ip,
			string $jsonData = ""
		): ActivityLog
		{
			$logItem = new ActivityLog();
			$logItem->categoryID = $categoryID;
			$logItem->userID = $accountID;
			$logItem->ip = $ip;
			$logItem->jsonData = $jsonData;
			$logItem->save();

			return $logItem;
		}

		public function __construct()
		{
			parent::__construct($this);
		}
	}